/*
 * Decompiled with CFR 0.152.
 */
package siscweb.contcentric;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import siscweb.contcentric.Continuation;

public class ContinuationGroup
implements Serializable {
    private static final long serialVersionUID = -3448029499944547457L;
    private String id;
    private Long ttl;
    private String sessionId;
    private Date creationDate;
    private Date visitDate;
    private Date expirationDate;
    private Map continuations;

    public ContinuationGroup() {
    }

    public ContinuationGroup(String id, Long ttl, String sessionId) {
        this.id = id;
        this.creationDate = new Date();
        this.ttl = ttl;
        this.sessionId = sessionId;
        this.touch();
        this.continuations = new HashMap();
    }

    public void touch() {
        Date now = new Date();
        this.setVisitDate(now);
        this.setExpirationDate(new Date(now.getTime() + 1000L * this.getTtl()));
    }

    public void addContinuation(Continuation continuation) {
        continuation.setGroup(this);
        this.continuations.put(continuation.getId(), continuation);
    }

    public String getId() {
        return this.id;
    }

    private void setId(String id) {
        this.id = id;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    private void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public Date getVisitDate() {
        return this.visitDate;
    }

    private void setVisitDate(Date visitDate) {
        this.visitDate = visitDate;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    private void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Map getContinuations() {
        return this.continuations;
    }

    private void setContinuations(Map continuations) {
        this.continuations = continuations;
    }
}

