/*
 * Decompiled with CFR 0.152.
 */
package siscweb.contcentric;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import sisc.data.Procedure;
import siscweb.contcentric.Continuation;
import siscweb.contcentric.ContinuationGroup;
import siscweb.contcentric.ContinuationStore;
import siscweb.contcentric.ContinuationStoreSingletonDecorator;
import siscweb.contcentric.SessionContinuationStore;

public class ContinuationTable
implements ContinuationStore,
Serializable,
HttpSessionBindingListener,
HttpSessionActivationListener {
    private static final long serialVersionUID = 3688505502258902323L;
    private HttpSession session;
    private final HashMap continuationGroups = new HashMap();
    private final HashMap continuations = new HashMap();

    private ContinuationTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContinuationTable getInstance(HttpSession session) {
        ContinuationTable ct;
        HttpSession httpSession = session;
        synchronized (httpSession) {
            ct = (ContinuationTable)session.getAttribute("continuation-table");
            if (ct == null) {
                ct = new ContinuationTable();
                session.setAttribute("continuation-table", (Object)ct);
                ct.register();
            }
        }
        return ct;
    }

    public String getId() {
        return this.session.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(HttpSession session, String groupId, String continuationId, Procedure procedure, long ttl) {
        ContinuationGroup continuationGroup = null;
        HashMap hashMap = this.continuationGroups;
        synchronized (hashMap) {
            continuationGroup = (ContinuationGroup)this.continuationGroups.get(groupId);
            if (continuationGroup != null) {
                continuationGroup.touch();
            } else {
                continuationGroup = new ContinuationGroup(groupId, new Long(ttl), session.getId());
                this.continuationGroups.put(groupId, continuationGroup);
            }
        }
        Continuation continuation = new Continuation(continuationId, procedure);
        continuationGroup.addContinuation(continuation);
        this.continuations.put(continuationId, continuation);
    }

    public Procedure fetch(HttpSession session, String continuationId) {
        Continuation continuation = (Continuation)this.continuations.get(continuationId);
        if (continuation != null) {
            continuation.getGroup().touch();
            return continuation.getProcedure();
        }
        return null;
    }

    public void clear(HttpSession session) {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        HashMap hashMap = this.continuationGroups;
        synchronized (hashMap) {
            this.continuationGroups.clear();
        }
        this.continuations.clear();
    }

    public int purgeExpired() {
        Date now = new Date();
        int n = 0;
        Iterator i = new ArrayList(this.continuationGroups.keySet()).iterator();
        while (i.hasNext()) {
            String continuationGroupId = (String)i.next();
            ContinuationGroup continuationGroup = (ContinuationGroup)this.continuationGroups.get(continuationGroupId);
            if (continuationGroup == null || now.compareTo(continuationGroup.getExpirationDate()) <= 0) continue;
            this.continuationGroups.remove(continuationGroupId);
            ++n;
            Iterator j = continuationGroup.getContinuations().keySet().iterator();
            while (j.hasNext()) {
                String continuationId = (String)j.next();
                this.continuations.remove(continuationId);
            }
        }
        return n;
    }

    public void valueBound(HttpSessionBindingEvent be) {
        this.session = be.getSession();
    }

    public void valueUnbound(HttpSessionBindingEvent be) {
        this.session = null;
    }

    public void sessionDidActivate(HttpSessionEvent se) {
        this.session = se.getSession();
        this.register();
    }

    public void sessionWillPassivate(HttpSessionEvent se) {
        this.unregister();
        this.session = null;
    }

    protected void register() {
        ContinuationStore store = ContinuationStoreSingletonDecorator.getInstance();
        if (store instanceof SessionContinuationStore) {
            ((SessionContinuationStore)store).register(this);
        }
    }

    protected void unregister() {
        ContinuationStore store = ContinuationStoreSingletonDecorator.getInstance();
        if (store instanceof SessionContinuationStore) {
            ((SessionContinuationStore)store).unregister(this);
        }
    }
}

