/*
 * Decompiled with CFR 0.152.
 */
package siscweb.web;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import siscweb.contcentric.ContinuationStore;

public class ContinuationStoreInitializer
implements ServletContextListener,
Runnable {
    ServletContext context;
    private Boolean isRunning = Boolean.FALSE;

    public void contextInitialized(ServletContextEvent contextEvent) {
        this.context = contextEvent.getServletContext();
        String contextName = this.context.getServletContextName();
        String className = this.context.getInitParameter("siscweb.continuation-store");
        if (className == null || "".equals(className.trim())) {
            throw new RuntimeException(contextName + " : No siscweb.continuation-store context parameter set.");
        }
        this.context.setAttribute("*SISCWEB.CONTINUATION-STORE*", (Object)ContinuationStore.Factory.create(className));
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        this.stop();
        this.context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        ContinuationStore continuationStore;
        if (this.context != null && (continuationStore = (ContinuationStore)this.context.getAttribute("*SISCWEB.CONTINUATION-STORE*")) != null) {
            Boolean bl = this.isRunning;
            synchronized (bl) {
                if (this.isRunning == Boolean.FALSE) {
                    this.isRunning = Boolean.TRUE;
                }
            }
            while (this.isRunning == Boolean.TRUE) {
                continuationStore.purgeExpired();
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void stop() {
        this.isRunning = Boolean.FALSE;
    }
}

