/*
 * Decompiled with CFR 0.152.
 */
package siscweb.web;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import siscweb.util.REPLThread;

public class REPLInitializer
implements ServletContextListener {
    private REPLThread repl;
    private String host;
    private String port;

    public void contextInitialized(ServletContextEvent contextEvent) {
        ServletContext context = contextEvent.getServletContext();
        String contextName = context.getServletContextName();
        try {
            this.host = context.getInitParameter("siscweb.repl-host");
            this.port = context.getInitParameter("siscweb.repl-port");
            if (this.host != null && this.port != null) {
                System.out.println(contextName + " : starting REPL on " + this.host + ":" + this.port);
                this.repl = new REPLThread(this.host, Integer.parseInt(this.port));
                this.repl.start();
            }
        }
        catch (NumberFormatException e) {
            System.err.println(contextName + " : invalid repl port specified (WARNING)");
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }

    public void contextDestroyed(ServletContextEvent contextEvent) {
        ServletContext context = contextEvent.getServletContext();
        String contextName = context.getServletContextName();
        if (this.repl != null) {
            System.out.println(contextName + " : stopping REPL on " + this.host + ":" + this.port + ".");
            this.repl.terminate();
        }
    }
}

