/*
 * Decompiled with CFR 0.152.
 */
package siscweb.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sisc.data.Procedure;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.Context;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeCaller;
import sisc.interpreter.SchemeException;
import sisc.modules.s2j.Util;

public class SISCAdapterServlet
extends HttpServlet {
    private static final long serialVersionUID = 7683553386599453481L;
    protected String contextName;
    private static final ThreadLocal request = new ThreadLocal();
    private static final ThreadLocal response = new ThreadLocal();

    public void init() throws ServletException {
        this.contextName = this.getServletContext().getServletContextName();
        this.evalInitParameter("on-init-sexp");
    }

    public void destroy() {
        this.evalInitParameter("on-destroy-sexp");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String servletName = this.getServletName();
        try {
            SISCAdapterServlet.request.set(request);
            SISCAdapterServlet.response.set(response);
            Context.execute((SchemeCaller)new SchemeCaller(){

                public Object execute(Interpreter r) throws SchemeException {
                    Procedure sisclet = (Procedure)r.eval((Value)Symbol.get((String)"sisclet"));
                    return r.eval(sisclet, new Value[0]);
                }
            });
        }
        catch (SchemeException e) {
            throw new ServletException(this.contextName + ": sisclet call failed in servlet " + servletName + ".", Util.javaException((SchemeException)e));
        }
        finally {
            SISCAdapterServlet.request.set(null);
            SISCAdapterServlet.response.set(null);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doGet(request, response);
    }

    private void evalInitParameter(final String name) throws RuntimeException {
        final String sexp = this.getInitParameter(name);
        if (sexp != null) {
            final String servletName = this.getServletName();
            try {
                Context.execute((SchemeCaller)new SchemeCaller(){

                    public Object execute(Interpreter r) throws SchemeException {
                        try {
                            Procedure currentDirectory = (Procedure)r.lookup(Symbol.get((String)"current-directory"), sisc.util.Util.TOPLEVEL);
                            r.eval(currentDirectory, new Value[]{new SchemeString(SISCAdapterServlet.this.getServletContext().getRealPath("/"))});
                            return r.eval(sexp);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(servletName + " : error evaluating context parameter " + name + ".", e);
                        }
                    }
                });
            }
            catch (SchemeException e) {
                System.err.println(this.contextName + " : error evaluating parameter '" + name + "' in servlet '" + this.getServletName() + "'. Scheme stack trace follows:");
                try {
                    Context.execute((SchemeCaller)new SchemeCaller(){

                        public Object execute(Interpreter r) throws SchemeException {
                            Procedure printError = (Procedure)r.lookup(Symbol.get((String)"print-error"), sisc.util.Util.TOPLEVEL);
                            return r.eval(printError, new Value[]{e.m, e.e});
                        }
                    });
                }
                catch (SchemeException f) {
                    throw new RuntimeException(this.contextName + " : error printing scheme stack trace during evaluation of parameter '" + name + "' in servlet '" + this.getServletName() + ".", Util.javaException((SchemeException)f));
                }
            }
        }
    }

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)request.get();
    }

    public static HttpServletResponse getResponse() {
        return (HttpServletResponse)response.get();
    }
}

