/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules;

import java.io.IOException;
import sisc.data.NamedValue;
import sisc.data.Quantity;
import sisc.data.SchemeString;
import sisc.data.SchemeThread;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.Context;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.ValueWriter;
import sisc.nativefun.CommonIndexedProcedure;
import sisc.nativefun.IndexedFixableProcedure;
import sisc.nativefun.IndexedLibraryAdapter;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;
import sisc.util.Util;

public class Threads
extends Util {
    protected static Symbol S_READY = Symbol.get((String)"ready");
    protected static Symbol S_RUNNING = Symbol.get((String)"running");
    protected static Symbol S_FINISHED = Symbol.get((String)"finished");
    protected static Symbol S_FINISHED_ABNORMALLY = Symbol.get((String)"finished-with-error");
    protected static final Symbol THREADB = Symbol.intern((String)"sisc.modules.Messages");
    protected static final Symbol MUTEX = Symbol.get((String)"mutex");
    protected static final int THREADNEW = 0;
    protected static final int THREADRESULT = 21;
    protected static final int THREADSTART = 1;
    protected static final int THREADYIELD = 2;
    protected static final int THREADSLEEP = 3;
    protected static final int THREADINTERRUPT = 4;
    protected static final int THREADJOIN = 5;
    protected static final int THREADCURRENT = 6;
    protected static final int THREADQ = 7;
    protected static final int THREADNOTIFY = 8;
    protected static final int THREADNOTIFYALL = 9;
    protected static final int THREADWAIT = 10;
    protected static final int THREADNAME = 11;
    protected static final int THREADPRIORITY = 12;
    protected static final int THREADDAEMONQ = 13;
    protected static final int SETTHREADNAME = 14;
    protected static final int SETTHREADPRIORITY = 15;
    protected static final int SETTHREADDAEMON = 16;
    protected static final int THREADSTATE = 17;
    protected static final int THREADINTERRUPTEDQ = 18;
    protected static final int THREADHOLDSLOCKQ = 19;
    protected static final int THREADSRUNNING = 20;
    protected static final int MUTEXNEW = 22;
    protected static final int MUTEXLOCK = 23;
    protected static final int MUTEXUNLOCK = 24;
    protected static final int CONDVARNOTIFY = 25;
    protected static final int CONDVARNOTIFYALL = 26;
    protected static final int MUTEXOF = 28;
    protected static final int MUTEXQ = 29;
    protected static final int CONDVARQ = 30;
    protected static final int CONDVARNEW = 31;
    protected static final int THREADSETRESULT = 32;
    static /* synthetic */ Class class$sisc$modules$Threads$Simple;
    static /* synthetic */ Class class$sisc$modules$Threads$Complex;

    public static final SchemeThread sthread(Value value) {
        try {
            return (SchemeThread)value;
        }
        catch (ClassCastException classCastException) {
            Threads.typeError((Symbol)THREADB, (String)"sthread", (Value)value);
            return null;
        }
    }

    public static final Mutex mutex(Value value) {
        try {
            return (Mutex)value;
        }
        catch (ClassCastException classCastException) {
            Threads.typeError((Symbol)THREADB, (String)"mutex", (Value)value);
            return null;
        }
    }

    public static final CondVar condvar(Value value) {
        try {
            return (CondVar)value;
        }
        catch (ClassCastException classCastException) {
            Threads.typeError((Symbol)THREADB, (String)"condvar", (Value)value);
            return null;
        }
    }

    static Symbol stateOf(SchemeThread schemeThread) {
        switch (schemeThread.getState()) {
            case 0: {
                return S_READY;
            }
            case 1: {
                return S_RUNNING;
            }
            case 2: {
                return S_FINISHED;
            }
            case 3: {
                return S_FINISHED_ABNORMALLY;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Complex
    extends CommonIndexedProcedure {
        public Complex() {
        }

        Complex(int n) {
            super(n);
        }

        public Value apply() throws ContinuationException {
            switch (this.id) {
                case 2: {
                    Thread.yield();
                    return VOID;
                }
            }
            Complex.throwArgSizeException();
            return VOID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Value apply(Interpreter interpreter, Value value) throws ContinuationException {
            switch (this.id) {
                case 0: {
                    return new SchemeThread(interpreter.dynenv, Complex.proc((Value)interpreter.vlr[0]));
                }
                case 21: {
                    return Threads.sthread(interpreter.vlr[0]).getResult(interpreter);
                }
                case 4: {
                    SchemeThread schemeThread = Threads.sthread(value);
                    schemeThread.thread.interrupt();
                    schemeThread.threadContext.interrupt = true;
                    return VOID;
                }
                case 25: {
                    Threads.condvar(value).c_notify();
                    return VOID;
                }
                case 26: {
                    Threads.condvar(value).c_notifyall();
                    return VOID;
                }
                case 23: {
                    return Threads.mutex(value).acquire();
                }
                case 24: {
                    Threads.mutex(value).unlock();
                    return TRUE;
                }
                case 1: {
                    SchemeThread schemeThread = Threads.sthread(value);
                    schemeThread.start();
                    while (schemeThread.state == 0) {
                        SchemeThread schemeThread2 = schemeThread;
                        synchronized (schemeThread2) {
                            try {
                                schemeThread.wait(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    return VOID;
                }
                case 5: {
                    SchemeThread schemeThread = Threads.sthread(value);
                    if (schemeThread.state >= 1) {
                        try {
                            schemeThread.thread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (schemeThread.state == 1) {
                            return FALSE;
                        }
                        return Threads.stateOf(schemeThread);
                    }
                    Complex.throwPrimException((String)Complex.liMessage((Symbol)THREADB, (String)"threadnotstarted"));
                }
            }
            Complex.throwArgSizeException();
            return VOID;
        }

        public Value apply(Value value, Value value2) throws ContinuationException {
            switch (this.id) {
                case 24: {
                    Threads.mutex(value).unlock(Threads.condvar(value2));
                    return TRUE;
                }
                case 23: {
                    long l = Complex.num((Value)value2).longValue();
                    return Threads.mutex(value).lock(l);
                }
                case 5: {
                    SchemeThread schemeThread = Threads.sthread(value);
                    if (schemeThread.state >= 1) {
                        try {
                            schemeThread.thread.join(Complex.num((Value)value2).indexValue());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (schemeThread.state == 1) {
                            return FALSE;
                        }
                        return Threads.stateOf(schemeThread);
                    }
                    throw new RuntimeException(Complex.liMessage((Symbol)THREADB, (String)"threadnotstarted"));
                }
                case 32: {
                    Threads.sthread((Value)value).rv = value2;
                    return VOID;
                }
                case 15: {
                    Threads.sthread((Value)value).thread.setPriority(Complex.num((Value)value2).indexValue());
                    return VOID;
                }
                case 16: {
                    Threads.sthread((Value)value).thread.setDaemon(Complex.truth((Value)value2));
                    return VOID;
                }
                case 14: {
                    SchemeThread schemeThread = Threads.sthread(value);
                    schemeThread.thread.setName(Complex.string((Value)value2));
                    return VOID;
                }
            }
            Complex.throwArgSizeException();
            return VOID;
        }

        public Value apply(Value value, Value value2, Value value3) throws ContinuationException {
            switch (this.id) {
                case 24: {
                    return Threads.mutex(value).unlock(Threads.condvar(value2), Complex.num((Value)value3).longValue());
                }
            }
            Complex.throwArgSizeException();
            return VOID;
        }
    }

    public static class Simple
    extends IndexedFixableProcedure {
        public Simple() {
        }

        Simple(int n) {
            super(n);
        }

        public Value apply() throws ContinuationException {
            switch (this.id) {
                case 22: {
                    return new Mutex();
                }
                case 31: {
                    return new CondVar();
                }
                case 6: {
                    SchemeThread schemeThread = (SchemeThread)Context.lookupThreadContext().hostThread.get();
                    if (schemeThread == null) {
                        return FALSE;
                    }
                    return schemeThread;
                }
            }
            Simple.throwArgSizeException();
            return VOID;
        }

        public Value apply(Value value) throws ContinuationException {
            switch (this.id) {
                case 7: {
                    return Simple.truth((boolean)(value instanceof SchemeThread));
                }
                case 29: {
                    return Simple.truth((boolean)(value instanceof Mutex));
                }
                case 30: {
                    return Simple.truth((boolean)(value instanceof CondVar));
                }
                case 28: {
                    return Mutex.of(value);
                }
                case 18: {
                    return Simple.truth((boolean)Threads.sthread((Value)value).threadContext.interrupt);
                }
                case 11: {
                    return new SchemeString(Threads.sthread((Value)value).thread.getName());
                }
                case 12: {
                    return Quantity.valueOf((int)Threads.sthread((Value)value).thread.getPriority());
                }
                case 13: {
                    return Simple.truth((boolean)Threads.sthread((Value)value).thread.isDaemon());
                }
                case 17: {
                    SchemeThread schemeThread = Threads.sthread(value);
                    return Threads.stateOf(schemeThread);
                }
            }
            Simple.throwArgSizeException();
            return VOID;
        }

        public Value apply(Value value, Value value2) throws ContinuationException {
            switch (this.id) {
                case 19: {
                    return Simple.truth((Threads.mutex(value2).owner == Threads.sthread((Value)value).thread ? 1 : 0) != 0);
                }
            }
            Simple.throwArgSizeException();
            return VOID;
        }
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Value construct(Object object, int n) {
            if (object == null || object == (class$sisc$modules$Threads$Simple == null ? (class$sisc$modules$Threads$Simple = Threads.class$("sisc.modules.Threads$Simple")) : class$sisc$modules$Threads$Simple)) {
                return new Simple(n);
            }
            return new Complex(n);
        }

        public Index() {
            this.define("thread/daemon!", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 16);
            this.define("thread/interrupt", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 4);
            this.define("thread/join", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 5);
            this.define("thread/name!", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 14);
            this.define("thread/new", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 0);
            this.define("thread/notify", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 8);
            this.define("thread/notify-all", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 9);
            this.define("thread/priority!", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 15);
            this.define("thread/result", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 21);
            this.define("thread/_set-result!", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 32);
            this.define("thread/start", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 1);
            this.define("thread/yield", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 2);
            this.define("condvar/notify", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 25);
            this.define("condvar/notify-all", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 26);
            this.define("mutex/lock!", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 23);
            this.define("mutex/unlock!", class$sisc$modules$Threads$Complex == null ? (class$sisc$modules$Threads$Complex = Threads.class$("sisc.modules.Threads$Complex")) : class$sisc$modules$Threads$Complex, 24);
            this.define("thread?", 7);
            this.define("thread/current", 6);
            this.define("thread/wait", 10);
            this.define("thread/name", 11);
            this.define("thread/daemon?", 13);
            this.define("thread/priority", 12);
            this.define("thread/state", 17);
            this.define("thread/interrupted?", 18);
            this.define("thread/holds-lock?", 19);
            this.define("thread/_active-thread-count", 20);
            this.define("condvar?", 30);
            this.define("condvar/new", 31);
            this.define("mutex?", 29);
            this.define("mutex-of", 28);
            this.define("mutex/new", 22);
        }
    }

    public static class Mutex
    extends Value
    implements NamedValue {
        private transient int lockCount = 0;
        private transient Thread owner = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Value lock(long l) {
            Thread thread = null;
            Mutex mutex = this;
            synchronized (mutex) {
                if (this.owner == null) {
                    this.owner = Thread.currentThread();
                } else {
                    thread = Thread.currentThread();
                    if (thread != this.owner) {
                        long l2 = System.currentTimeMillis();
                        while (this.lockCount > 0) {
                            try {
                                ((Object)((Object)this)).wait(l);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            long l3 = System.currentTimeMillis();
                            if ((l -= l3 - l2) <= 0L) {
                                return FALSE;
                            }
                            l2 = l3;
                        }
                        this.owner = thread;
                    }
                }
                ++this.lockCount;
                return TRUE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Value acquire() {
            Thread thread = Thread.currentThread();
            if (this.owner == thread) {
                ++this.lockCount;
            } else {
                Mutex mutex = this;
                synchronized (mutex) {
                    while (this.lockCount > 0) {
                        try {
                            ((Object)((Object)this)).wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    ++this.lockCount;
                }
                this.owner = thread;
            }
            return TRUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void unlock() {
            if (this.owner == Thread.currentThread()) {
                Mutex mutex = this;
                synchronized (mutex) {
                    if (--this.lockCount == 0) {
                        this.owner = null;
                        ((Object)((Object)this)).notify();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void unlockAll() {
            if (this.owner == Thread.currentThread()) {
                Mutex mutex = this;
                synchronized (mutex) {
                    this.lockCount = 0;
                    this.owner = null;
                    ((Object)((Object)this)).notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(CondVar condVar) {
            while (true) {
                try {
                    CondVar condVar2 = condVar;
                    synchronized (condVar2) {
                        this.unlockAll();
                        ((Object)((Object)condVar)).wait();
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Value unlock(CondVar condVar, long l) {
            while (true) {
                try {
                    CondVar condVar2 = condVar;
                    synchronized (condVar2) {
                        this.unlockAll();
                        long l2 = System.currentTimeMillis();
                        ((Object)((Object)condVar)).wait(l);
                        if (System.currentTimeMillis() - l2 >= l) {
                            return FALSE;
                        }
                    }
                    return TRUE;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public void display(ValueWriter valueWriter) throws IOException {
            this.displayNamedOpaque(valueWriter, "mutex");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Mutex of(Value value) {
            Value value2 = value;
            synchronized (value2) {
                Value value3 = value.getAnnotation(MUTEX);
                if (value3 == FALSE) {
                    value3 = new Mutex();
                    value.setAnnotation(MUTEX, value3);
                }
                return Threads.mutex(value3);
            }
        }

        public void serialize(Serializer serializer) throws IOException {
            if (this.lockCount > 0 || this.owner != null) {
                Mutex.warn((String)"serializinglockedmutex");
            }
        }

        public boolean visit(ExpressionVisitor expressionVisitor) {
            return super.visit(expressionVisitor);
        }
    }

    public static class CondVar
    extends Value
    implements NamedValue {
        public void display(ValueWriter valueWriter) throws IOException {
            this.displayNamedOpaque(valueWriter, "condvar");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void c_notify() {
            CondVar condVar = this;
            synchronized (condVar) {
                ((Object)((Object)this)).notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void c_notifyall() {
            CondVar condVar = this;
            synchronized (condVar) {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }
}

