/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.io;

import java.io.IOException;
import sisc.data.NamedValue;
import sisc.data.Value;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;

public class Buffer
extends Value
implements NamedValue {
    public byte[] buf;

    public Buffer(int n) {
        this(new byte[n]);
    }

    public Buffer(int n, byte by) {
        this(n);
        for (int i = 0; i < this.buf.length; ++i) {
            this.buf[i] = by;
        }
    }

    public Buffer(byte[] byArray) {
        this.buf = byArray;
    }

    public final byte ref(int n) {
        return this.buf[n];
    }

    public final void set(int n, byte by) {
        this.buf[n] = by;
    }

    public void display(ValueWriter valueWriter) throws IOException {
        this.displayNamedOpaque(valueWriter, "buffer");
    }

    public Buffer() {
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeInt(this.buf.length);
        serializer.write(this.buf);
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.buf = new byte[deserializer.readInt()];
        deserializer.read(this.buf, 0, this.buf.length);
    }
}

