/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.StreamInputPort;
import sisc.io.StreamOutputPort;
import sisc.modules.io.BinaryIO;
import sisc.modules.io.Buffer;
import sisc.nativefun.IndexedLibraryAdapter;
import sisc.nativefun.IndexedProcedure;

public class BufferIO
extends IndexedProcedure {
    protected static Symbol BINARYB = Symbol.intern((String)"sisc.modules.io.Messages");
    protected static final int OPENINPUTBUFFER = 0;
    protected static final int OPENOUTPUTBUFFER = 1;
    protected static final int GETOUTPUTBUFFER = 2;

    public BufferIO(int n) {
        super(n);
    }

    public BufferIO() {
    }

    public Value doApply(Interpreter interpreter) throws ContinuationException {
        switch (interpreter.vlr.length) {
            case 0: {
                switch (this.id) {
                    case 1: {
                        return new StreamOutputPort((OutputStream)new ByteArrayOutputStream(), false);
                    }
                }
                BufferIO.throwArgSizeException();
            }
            case 1: {
                switch (this.id) {
                    case 2: {
                        StreamOutputPort streamOutputPort = (StreamOutputPort)interpreter.vlr[0];
                        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)streamOutputPort.out;
                        try {
                            streamOutputPort.flush();
                        }
                        catch (IOException iOException) {
                            BufferIO.throwPrimException((String)BufferIO.liMessage((Symbol)BINARYB, (String)"errorflushing", (String)streamOutputPort.toString(), (String)iOException.getMessage()));
                        }
                        Buffer buffer = new Buffer(byteArrayOutputStream.toByteArray());
                        byteArrayOutputStream.reset();
                        return buffer;
                    }
                    case 0: {
                        return new StreamInputPort((InputStream)new ByteArrayInputStream(BinaryIO.buffer((Value)interpreter.vlr[0]).buf));
                    }
                    case 1: {
                        return new StreamOutputPort((OutputStream)new ByteArrayOutputStream(BufferIO.num((Value)interpreter.vlr[0]).indexValue()), false);
                    }
                }
                BufferIO.throwArgSizeException();
            }
        }
        BufferIO.throwArgSizeException();
        return VOID;
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Value construct(Object object, int n) {
            return new BufferIO(n);
        }

        public Index() {
            this.define("_get-output-buffer", 2);
            this.define("_open-input-buffer", 0);
            this.define("_open-output-buffer", 1);
        }
    }
}

