/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.record;

import java.io.IOException;
import sisc.data.Expression;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.io.ValueWriter;
import sisc.modules.record.Primitives;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitee;
import sisc.util.ExpressionVisitor;
import sisc.util.Util;

public class Record
extends Value {
    private Value type;
    private Value[] slots;

    public Record() {
    }

    public Record(Value value, int n) {
        this.type = value;
        this.slots = new Value[n];
        for (int i = 0; i < n; ++i) {
            this.slots[i] = VOID;
        }
    }

    public Value getType() {
        return this.type;
    }

    public void setType(Value value) {
        this.type = value;
    }

    public Value getSlot(int n) {
        return this.slots[n];
    }

    public void setSlot(int n, Value value) {
        this.slots[n] = value;
    }

    public int size() {
        return this.slots.length;
    }

    public boolean valueEqual(Value value) {
        if (value == this) {
            return true;
        }
        if (!(value instanceof Record)) {
            return false;
        }
        Record record = (Record)value;
        if (this.type != record.getType() || this.size() != record.size()) {
            return false;
        }
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i].valueEqual(record.getSlot(i))) continue;
            return false;
        }
        return true;
    }

    public int valueHashCode() {
        int n = System.identityHashCode(this.type);
        for (int i = 0; i < this.slots.length; ++i) {
            n ^= this.slots[i].valueHashCode();
        }
        return n;
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeExpression((Expression)this.type);
        serializer.writeInt(this.size());
        for (int i = 0; i < this.slots.length; ++i) {
            serializer.writeExpression((Expression)this.slots[i]);
        }
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.type = (Value)deserializer.readExpression();
        this.slots = new Value[deserializer.readInt()];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = (Value)deserializer.readExpression();
        }
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        if (!expressionVisitor.visit((ExpressionVisitee)this.type)) {
            return false;
        }
        for (int i = 0; i < this.slots.length; ++i) {
            if (expressionVisitor.visit((ExpressionVisitee)this.slots[i])) continue;
            return false;
        }
        return true;
    }

    public void display(ValueWriter valueWriter) throws IOException {
        valueWriter.append("#<").append(Util.liMessage((Symbol)Primitives.SRECORDB, (String)"record")).append(' ').append(this.type).append(" [");
        for (int i = 0; i < this.slots.length - 1; ++i) {
            valueWriter.append(this.slots[i]).append(' ');
        }
        if (this.slots.length > 0) {
            valueWriter.append(this.slots[this.slots.length - 1]);
        }
        valueWriter.append("]>");
    }
}

