/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.s2j;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import sisc.data.EmptyList;
import sisc.data.Pair;
import sisc.data.Quantity;
import sisc.data.SchemeCharacter;
import sisc.data.SchemeString;
import sisc.data.SchemeVector;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.modules.s2j.Util;
import sisc.nativefun.IndexedLibraryAdapter;

public class Conversion
extends Util {
    protected static final int CONV_JBOOLEAN = 1;
    protected static final int CONV_JCHAR = 2;
    protected static final int CONV_JBYTE = 3;
    protected static final int CONV_JSHORT = 4;
    protected static final int CONV_JINT = 5;
    protected static final int CONV_JLONG = 6;
    protected static final int CONV_JFLOAT = 7;
    protected static final int CONV_JDOUBLE = 8;
    protected static final int CONV_JSTRING = 9;
    protected static final int CONV_JARRAY = 10;
    protected static final int CONV_BOOLEAN = 20;
    protected static final int CONV_CHARACTER = 21;
    protected static final int CONV_NUMBER = 22;
    protected static final int CONV_STRING = 23;
    protected static final int CONV_SYMBOL = 24;
    protected static final int CONV_VECTOR = 25;
    protected static final int CONV_LIST = 26;

    public Conversion(int n) {
        super(n);
    }

    public Conversion() {
    }

    public Value apply(Value value) throws ContinuationException {
        switch (this.id) {
            case 1: {
                return Conversion.makeJObj(Conversion.truth((Value)value) ? Boolean.TRUE : Boolean.FALSE, Boolean.TYPE);
            }
            case 2: {
                return Conversion.makeJObj(new Character(Conversion.character((Value)value)), Character.TYPE);
            }
            case 3: {
                return Conversion.makeJObj(new Byte((byte)Conversion.num((Value)value).intValue()), Byte.TYPE);
            }
            case 4: {
                return Conversion.makeJObj(new Short((short)Conversion.num((Value)value).intValue()), Short.TYPE);
            }
            case 5: {
                return Conversion.makeJObj(new Integer(Conversion.num((Value)value).intValue()), Integer.TYPE);
            }
            case 6: {
                return Conversion.makeJObj(new Long(Conversion.num((Value)value).longValue()), Long.TYPE);
            }
            case 7: {
                return Conversion.makeJObj(new Float((float)Conversion.num((Value)value).doubleValue()), Float.TYPE);
            }
            case 8: {
                return Conversion.makeJObj(new Double(Conversion.num((Value)value).doubleValue()), Double.TYPE);
            }
            case 9: {
                Value value2 = value;
                if (value2 instanceof Symbol) {
                    return Conversion.makeJObj(Conversion.symval((Value)value2));
                }
                if (value2 instanceof SchemeString) {
                    return Conversion.makeJObj(Conversion.string((Value)value2));
                }
                Conversion.typeError((Symbol)S2JB, (String)"stringorsymbol", (Value)value2);
            }
            case 20: {
                return Conversion.truth((boolean)((Boolean)Conversion.jobj(value)));
            }
            case 21: {
                return new SchemeCharacter(((Character)Conversion.jobj(value)).charValue());
            }
            case 22: {
                Object object = Conversion.jobj(value);
                if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
                    return Quantity.valueOf((long)((Number)object).longValue());
                }
                if (object instanceof Float || object instanceof Double) {
                    return Quantity.valueOf((double)((Number)object).doubleValue());
                }
                if (object instanceof BigInteger) {
                    return Quantity.valueOf((BigInteger)((BigInteger)object));
                }
                if (object instanceof BigDecimal) {
                    return Quantity.valueOf((BigDecimal)((BigDecimal)object));
                }
                Conversion.typeError((Symbol)S2JB, (String)"jnumber", (Value)value);
            }
            case 23: {
                Object object = Conversion.jobj(value);
                if (object instanceof String) {
                    return new SchemeString((String)object);
                }
                return new SchemeString(object.toString());
            }
            case 24: {
                Object object = Conversion.jobj(value);
                if (object instanceof String) {
                    return Symbol.intern((String)((String)object));
                }
                return Symbol.intern((String)object.toString());
            }
            case 25: {
                Object object = Conversion.jobj(value);
                if (object.getClass().isArray()) {
                    Class<?> clazz = object.getClass().getComponentType();
                    Value[] valueArray = new Value[Array.getLength(object)];
                    for (int i = 0; i < valueArray.length; ++i) {
                        valueArray[i] = Conversion.makeJObj(Array.get(object, i), clazz);
                    }
                    return new SchemeVector(valueArray);
                }
                Conversion.typeError((Symbol)S2JB, (String)"jarray", (Value)value);
            }
            case 26: {
                Object object = Conversion.jobj(value);
                if (object.getClass().isArray()) {
                    Class<?> clazz = object.getClass().getComponentType();
                    EmptyList emptyList = EMPTYLIST;
                    for (int i = Array.getLength(object) - 1; i >= 0; --i) {
                        emptyList = new Pair((Value)Conversion.makeJObj(Array.get(object, i), clazz), (Value)emptyList);
                    }
                    return emptyList;
                }
                Conversion.typeError((Symbol)S2JB, (String)"jarray", (Value)value);
            }
        }
        Conversion.throwArgSizeException();
        return VOID;
    }

    public Value apply(Value value, Value value2) throws ContinuationException {
        switch (this.id) {
            case 10: {
                Value value3 = value;
                Value[] valueArray = null;
                if (value3 instanceof Pair) {
                    valueArray = Conversion.pairToValues((Pair)Conversion.pair((Value)value3));
                } else if (value3 instanceof SchemeVector) {
                    valueArray = Conversion.vec((Value)value3).vals;
                } else {
                    Conversion.typeError((Symbol)S2JB, (String)"listorvector", (Value)value3);
                }
                Object object = Array.newInstance(Conversion.jclass(value2), valueArray.length);
                for (int i = 0; i < valueArray.length; ++i) {
                    Array.set(object, i, Conversion.jobj(valueArray[i]));
                }
                return Conversion.makeJObj(object);
            }
        }
        Conversion.throwArgSizeException();
        return VOID;
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Value construct(Object object, int n) {
            return new Conversion(n);
        }

        public Index() {
            this.define("->jboolean", 1);
            this.define("->jchar", 2);
            this.define("->jbyte", 3);
            this.define("->jshort", 4);
            this.define("->jint", 5);
            this.define("->jlong", 6);
            this.define("->jfloat", 7);
            this.define("->jdouble", 8);
            this.define("->jstring", 9);
            this.define("->jarray", 10);
            this.define("->boolean", 20);
            this.define("->character", 21);
            this.define("->number", 22);
            this.define("->string", 23);
            this.define("->symbol", 24);
            this.define("->vector", 25);
            this.define("->list", 26);
        }
    }
}

