/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.s2j;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sisc.data.Expression;
import sisc.data.Pair;
import sisc.data.Procedure;
import sisc.data.SchemeVector;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.ValueWriter;
import sisc.modules.s2j.Util;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitee;
import sisc.util.ExpressionVisitor;

public class JavaObject
extends Procedure {
    protected Object obj;
    public static final byte JUNKN = 0;
    public static final byte JNULL = 1;
    public static final byte JCLASS = 2;
    public static final byte JFIELD = 3;
    public static final byte JMETHOD = 4;
    public static final byte JCONSTR = 5;
    public static final byte JARRAY = 6;
    public static final byte JOBJ = 7;
    protected byte objType = 0;
    static /* synthetic */ Class class$sisc$modules$s2j$JavaObject;
    static /* synthetic */ Class class$java$lang$Throwable;

    public byte getObjType() {
        if (this.objType == 0) {
            this.objType = (byte)(this.obj instanceof Class ? 2 : (this.obj instanceof Field ? 3 : (this.obj instanceof Method ? 4 : (this.obj instanceof Constructor ? 5 : (this.obj.getClass().isArray() ? 6 : 7)))));
        }
        return this.objType;
    }

    public JavaObject() {
    }

    public void serialize(Serializer serializer) throws IOException {
        byte by = this.getObjType();
        serializer.writeByte((int)by);
        switch (by) {
            case 2: {
                serializer.writeUTF(Util.nameType((Class)this.obj));
                break;
            }
            case 3: {
                Field field = (Field)this.obj;
                serializer.writeUTF(Util.nameType(field.getDeclaringClass()));
                serializer.writeUTF(field.getName());
                break;
            }
            case 4: {
                Method method = (Method)this.obj;
                serializer.writeUTF(Util.nameType(method.getDeclaringClass()));
                serializer.writeUTF(method.getName());
                Class<?>[] classArray = method.getParameterTypes();
                serializer.writeInt(classArray.length);
                for (int i = 0; i < classArray.length; ++i) {
                    serializer.writeUTF(Util.nameType(classArray[i]));
                }
                break;
            }
            case 5: {
                Constructor constructor = (Constructor)this.obj;
                serializer.writeUTF(Util.nameType(constructor.getDeclaringClass()));
                Class<?>[] classArray = constructor.getParameterTypes();
                serializer.writeInt(classArray.length);
                for (int i = 0; i < classArray.length; ++i) {
                    serializer.writeUTF(Util.nameType(classArray[i]));
                }
                break;
            }
            default: {
                serializer.writeObject(this.obj);
            }
        }
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        byte by = deserializer.readByte();
        switch (by) {
            case 2: {
                this.obj = Util.resolveType(deserializer.readUTF());
                break;
            }
            case 3: {
                try {
                    Class clazz = Util.resolveType(deserializer.readUTF());
                    this.obj = clazz.getDeclaredField(deserializer.readUTF());
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"cannotdeserialize"));
                }
            }
            case 4: {
                try {
                    Class clazz = Util.resolveType(deserializer.readUTF());
                    String string = deserializer.readUTF();
                    int n = deserializer.readInt();
                    Class[] classArray = new Class[n];
                    for (int i = 0; i < n; ++i) {
                        classArray[i] = Util.resolveType(deserializer.readUTF());
                    }
                    this.obj = clazz.getDeclaredMethod(string, classArray);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"cannotdeserialize"));
                }
            }
            case 5: {
                try {
                    Class clazz = Util.resolveType(deserializer.readUTF());
                    int n = deserializer.readInt();
                    Class[] classArray = new Class[n];
                    for (int i = 0; i < n; ++i) {
                        classArray[i] = Util.resolveType(deserializer.readUTF());
                    }
                    this.obj = clazz.getDeclaredConstructor(classArray);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"cannotdeserialize"));
                }
            }
            default: {
                try {
                    this.obj = deserializer.readObject();
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"cannotdeserialize"));
                }
            }
        }
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return this.obj != null && this.obj instanceof Expression ? expressionVisitor.visit((ExpressionVisitee)((Expression)this.obj)) : true;
    }

    public JavaObject(Object object) {
        this.obj = object;
    }

    public Object get() {
        return this.obj;
    }

    public Class classOf() {
        return this.obj.getClass();
    }

    public void display(ValueWriter valueWriter) throws IOException {
        valueWriter.append("#<java ").append(Util.nameType(this.obj.getClass())).append(' ').append(this.getObjType() == 2 ? Util.nameType((Class)this.obj) : this.obj.toString()).append('>');
    }

    public int hashCode() {
        return this.obj.hashCode();
    }

    public boolean eqv(Object object) {
        return this == object || object != null && object.getClass() == (class$sisc$modules$s2j$JavaObject == null ? (class$sisc$modules$s2j$JavaObject = JavaObject.class$("sisc.modules.s2j.JavaObject")) : class$sisc$modules$s2j$JavaObject) && this.obj == ((JavaObject)((Object)object)).obj;
    }

    public boolean valueEqual(Value value) {
        return this.eqv(value) || value instanceof JavaObject && this.obj.equals(((JavaObject)value).get());
    }

    public void apply(Interpreter interpreter) throws ContinuationException {
        try {
            switch (this.getObjType()) {
                case 2: {
                    interpreter.acc = JavaObject.apply((Class)this.obj, interpreter.vlr);
                    break;
                }
                case 3: {
                    interpreter.acc = JavaObject.apply((Field)this.obj, interpreter.vlr);
                    break;
                }
                case 4: {
                    interpreter.acc = JavaObject.apply((Method)this.obj, interpreter.vlr);
                    break;
                }
                case 5: {
                    interpreter.acc = JavaObject.apply((Constructor)this.obj, interpreter.vlr);
                    break;
                }
                case 6: {
                    interpreter.acc = JavaObject.applyArray(this.obj, interpreter.vlr);
                    break;
                }
                case 7: {
                    interpreter.acc = JavaObject.apply(this.obj, interpreter.vlr);
                    break;
                }
                case 1: {
                    JavaObject.error((Interpreter)interpreter, (String)JavaObject.liMessage((Symbol)Util.S2JB, (String)"cannotapplynull"));
                }
                default: {
                    JavaObject.error((Interpreter)interpreter, (String)JavaObject.liMessage((Symbol)Util.S2JB, (String)"cannotapplyobject", (String)this.obj.toString()));
                    break;
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            JavaObject.error((Interpreter)interpreter, (Value)Util.makeJObj(invocationTargetException.getTargetException(), class$java$lang$Throwable == null ? (class$java$lang$Throwable = JavaObject.class$("java.lang.Throwable")) : class$java$lang$Throwable));
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace(System.err);
            JavaObject.error((Interpreter)interpreter, (String)runtimeException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            JavaObject.error((Interpreter)interpreter, (String)exception.getMessage());
        }
        interpreter.nxp = null;
    }

    protected static final Value apply(Class clazz, Value[] valueArray) {
        try {
            switch (valueArray.length) {
                case 0: {
                    return Util.makeJObj(clazz.newInstance(), clazz);
                }
                case 1: {
                    Field field = clazz.getField(Util.mangleFieldName(JavaObject.symval((Value)valueArray[0])));
                    return Util.makeJObj(field.get(null), field.getType());
                }
                case 2: {
                    clazz.getField(Util.mangleFieldName(JavaObject.symval((Value)valueArray[0]))).set(null, Util.jobj(valueArray[1]));
                    return VOID;
                }
            }
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"zerotwoargs", (String)JavaObject.liMessage((Symbol)Util.S2JB, (String)"jclass"), (String)clazz.toString()));
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"errorinstantiating", (String)clazz.toString()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"illegalaccess", (Object[])new Object[]{JavaObject.liMessage((Symbol)Util.S2JB, (String)"jconstructor"), "default", clazz.toString()}));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"nosuchfield", (String)valueArray[0].toString(), (String)clazz.toString()));
        }
    }

    protected static final Value apply(Field field, Value[] valueArray) {
        try {
            switch (valueArray.length) {
                case 1: {
                    return Util.makeJObj(field.get(Util.jobj(valueArray[0])), field.getType());
                }
                case 2: {
                    field.set(Util.jobj(valueArray[0]), Util.jobj(valueArray[1]));
                    return VOID;
                }
            }
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"onetwoargs", (String)JavaObject.liMessage((Symbol)Util.S2JB, (String)"jfield"), (String)field.toString()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"illegalaccess", (Object[])new Object[]{JavaObject.liMessage((Symbol)Util.S2JB, (String)"jfield"), field.toString(), valueArray[0].toString()}));
        }
    }

    protected static final Value apply(Method method, Value[] valueArray) throws InvocationTargetException {
        Object object = Util.jobj(valueArray[0]);
        Object[] objectArray = new Object[valueArray.length - 1];
        for (int i = 0; i < valueArray.length - 1; ++i) {
            objectArray[i] = Util.jobj(valueArray[i + 1]);
        }
        try {
            return Util.makeJObj(method.invoke(object, objectArray), method.getReturnType());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"illegalaccess", (Object[])new Object[]{JavaObject.liMessage((Symbol)Util.S2JB, (String)"jmethod"), method.toString(), object.toString()}));
        }
    }

    protected static final Value apply(Constructor constructor, Value[] valueArray) throws InvocationTargetException {
        Object[] objectArray = new Object[valueArray.length];
        for (int i = 0; i < valueArray.length; ++i) {
            objectArray[i] = Util.jobj(valueArray[i]);
        }
        try {
            return Util.makeJObj(constructor.newInstance(objectArray), constructor.getDeclaringClass());
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"constructorerror", (String)constructor.toString(), (String)Util.nameType(constructor.getDeclaringClass())));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"illegalaccess", (Object[])new Object[]{JavaObject.liMessage((Symbol)Util.S2JB, (String)"jconstructor"), constructor.toString(), Util.nameType(constructor.getDeclaringClass())}));
        }
    }

    protected static final Value applyArray(Object object, Value[] valueArray) {
        switch (valueArray.length) {
            case 1: {
                Object object2 = null;
                if (valueArray[0] instanceof Pair) {
                    Pair pair = JavaObject.pair((Value)valueArray[0]);
                    while (pair != EMPTYLIST) {
                        object2 = object;
                        object = Array.get(object, JavaObject.num((Value)pair.car()).indexValue());
                        pair = JavaObject.pair((Value)pair.cdr());
                    }
                } else if (valueArray[0] instanceof SchemeVector) {
                    Value[] valueArray2 = ((SchemeVector)valueArray[0]).vals;
                    for (int i = 0; i < valueArray2.length; ++i) {
                        object2 = object;
                        object = Array.get(object, JavaObject.num((Value)valueArray2[i]).indexValue());
                    }
                } else {
                    object2 = object;
                    object = Array.get(object, JavaObject.num((Value)valueArray[0]).indexValue());
                }
                return Util.makeJObj(object, object2.getClass().getComponentType());
            }
            case 2: {
                Value value = null;
                if (valueArray[0] instanceof Pair) {
                    Pair pair = JavaObject.pair((Value)valueArray[0]);
                    if (pair == EMPTYLIST) {
                        return VOID;
                    }
                    while (pair.cdr() != EMPTYLIST) {
                        object = Array.get(object, JavaObject.num((Value)pair.car()).indexValue());
                        pair = JavaObject.pair((Value)pair.cdr());
                    }
                    value = pair.car();
                } else if (valueArray[0] instanceof SchemeVector) {
                    Value[] valueArray3 = ((SchemeVector)valueArray[0]).vals;
                    for (int i = 0; i < valueArray3.length - 1; ++i) {
                        object = Array.get(object, JavaObject.num((Value)valueArray3[i]).indexValue());
                    }
                    value = valueArray3[valueArray3.length - 1];
                } else {
                    value = valueArray[0];
                }
                Array.set(object, JavaObject.num((Value)value).indexValue(), Util.jobj(valueArray[1]));
                return VOID;
            }
        }
        throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"onetwoargs", (String)JavaObject.liMessage((Symbol)Util.S2JB, (String)"jarray"), (String)object.toString()));
    }

    protected static final FieldAccessor accessField(Class clazz, String string) throws NoSuchFieldException {
        Object object;
        try {
            object = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            for (int i = 0; i < ((PropertyDescriptor[])object).length; ++i) {
                PropertyDescriptor propertyDescriptor = object[i];
                if (!propertyDescriptor.getName().equals(string)) continue;
                return new BeanFieldAccessor(propertyDescriptor);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        object = clazz.getField(string);
        return new NormalFieldAccessor((Field)object);
    }

    protected static final Value accessBeanField(Object object, Value[] valueArray) throws InvocationTargetException {
        String string = null;
        try {
            FieldAccessor fieldAccessor = null;
            Pair pair = JavaObject.pair((Value)valueArray[0]);
            while (true) {
                string = Util.mangleFieldName(JavaObject.symval((Value)pair.car()));
                fieldAccessor = JavaObject.accessField(object.getClass(), string);
                if (pair.cdr() == EMPTYLIST) break;
                object = fieldAccessor.get(object);
                pair = JavaObject.pair((Value)pair.cdr());
            }
            switch (valueArray.length) {
                case 1: {
                    return Util.makeJObj(fieldAccessor.get(object), fieldAccessor.getType());
                }
                case 2: {
                    fieldAccessor.set(object, Util.jobj(valueArray[1]));
                    return VOID;
                }
            }
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"onetwoargs", (String)JavaObject.liMessage((Symbol)Util.S2JB, (String)"jobject"), (String)object.toString()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"illegalaccess", (Object[])new Object[]{JavaObject.liMessage((Symbol)Util.S2JB, (String)"jobject"), string, object.toString()}));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"nosuchfield", string, (String)object.toString()));
        }
    }

    protected static final Value apply(Object object, Value[] valueArray) throws InvocationTargetException {
        if (!(valueArray[0] instanceof Symbol)) {
            return JavaObject.accessBeanField(object, valueArray);
        }
        String string = Util.mangleFieldName(JavaObject.symval((Value)valueArray[0]));
        try {
            switch (valueArray.length) {
                case 1: {
                    Field field = object.getClass().getField(string);
                    return Util.makeJObj(field.get(object), field.getType());
                }
                case 2: {
                    object.getClass().getField(string).set(object, Util.jobj(valueArray[1]));
                    return VOID;
                }
            }
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"onetwoargs", (String)JavaObject.liMessage((Symbol)Util.S2JB, (String)"jobject"), (String)object.toString()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"illegalaccess", (Object[])new Object[]{JavaObject.liMessage((Symbol)Util.S2JB, (String)"jobject"), string, object.toString()}));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(JavaObject.liMessage((Symbol)Util.S2JB, (String)"nosuchfield", (String)string, (String)object.toString()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class NormalFieldAccessor
    implements FieldAccessor {
        private Field f;

        public NormalFieldAccessor(Field field) {
            this.f = field;
        }

        public Object get(Object object) throws IllegalAccessException {
            return this.f.get(object);
        }

        public void set(Object object, Object object2) throws IllegalAccessException {
            this.f.set(object, object2);
        }

        public Class getType() {
            return this.f.getType();
        }
    }

    public static class BeanFieldAccessor
    implements FieldAccessor {
        private PropertyDescriptor d;

        public BeanFieldAccessor(PropertyDescriptor propertyDescriptor) {
            this.d = propertyDescriptor;
        }

        public Object get(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.d.getReadMethod().invoke(object, new Object[0]);
        }

        public void set(Object object, Object object2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.d.getWriteMethod().invoke(object, object2);
        }

        public Class getType() {
            return this.d.getPropertyType();
        }
    }

    public static interface FieldAccessor {
        public Object get(Object var1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public void set(Object var1, Object var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public Class getType();
    }
}

