/*
 * Decompiled with CFR 0.152.
 */
package sisc.data;

import java.io.IOException;
import java.lang.ref.WeakReference;
import sisc.data.NamedValue;
import sisc.data.Procedure;
import sisc.data.Value;
import sisc.data.Values;
import sisc.env.DynamicEnvironment;
import sisc.interpreter.Context;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeException;
import sisc.interpreter.ThreadContext;
import sisc.io.ValueWriter;

public class SchemeThread
extends Value
implements Runnable,
NamedValue {
    public static final int READY = 0;
    public static final int RUNNING = 1;
    public static final int FINISHED = 2;
    public static final int FINISHED_ABNORMALLY = 3;
    public static final ThreadGroup schemeThreads = new ThreadGroup("SISC Threads");
    public DynamicEnvironment env;
    public Procedure thunk;
    public Thread thread;
    public ThreadContext threadContext;
    public int state;
    public Value rv;

    public SchemeThread(DynamicEnvironment dynamicEnvironment, Procedure procedure) {
        this.env = dynamicEnvironment.copy();
        this.env.wind = FALSE;
        this.thunk = procedure;
        this.thread = new Thread(schemeThreads, this);
        this.state = 0;
    }

    public Value getResult(Interpreter interpreter) throws ContinuationException {
        if (this.state < 2) {
            throw new RuntimeException(SchemeThread.liMessage(SISCB, "threadnotyetterminated"));
        }
        if (this.state == 2) {
            return this.rv;
        }
        interpreter.acc = this.rv;
        throw new ContinuationException(interpreter.fk);
    }

    public int getState() {
        return this.state;
    }

    public void start() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.threadContext = Context.lookupThreadContext();
        Interpreter interpreter = Context.enter(this.env);
        Context.lookupThreadContext().hostThread = new WeakReference<SchemeThread>(this);
        this.state = 1;
        SchemeThread schemeThread = this;
        synchronized (schemeThread) {
            this.notify();
        }
        try {
            this.rv = interpreter.eval(this.thunk, new Value[0]);
            this.state = 2;
        }
        catch (SchemeException schemeException) {
            this.rv = new Values(new Value[]{schemeException.m, schemeException.e});
            this.state = 3;
        }
        Context.exit();
    }

    public void display(ValueWriter valueWriter) throws IOException {
        this.displayNamedOpaque(valueWriter, "thread");
    }
}

