/*
 * Decompiled with CFR 0.152.
 */
package sisc.data;

import java.io.IOException;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class Values
extends Value {
    public Value[] values;

    public Values(Value[] valueArray) {
        this.values = valueArray;
    }

    public void display(ValueWriter valueWriter) throws IOException {
        for (int i = 0; i < this.values.length - 1; ++i) {
            valueWriter.append(this.values[i]).append('\n');
        }
        if (this.values.length > 0) {
            valueWriter.append(this.values[this.values.length - 1]);
        }
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        Values.error(interpreter, Values.liMessage(SISCB, "multiplevalues"));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Values)) {
            return false;
        }
        Values values = (Values)object;
        if (values.values.length != this.values.length) {
            return false;
        }
        for (int i = this.values.length - 1; i >= 0; --i) {
            if (this.values[i].equals(values.values[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.values.length; ++i) {
            n ^= this.values[i].hashCode();
        }
        return n;
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeInt(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            serializer.writeExpression(this.values[i]);
        }
    }

    public Values() {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        int n = deserializer.readInt();
        this.values = new Value[n];
        for (int i = 0; i < n; ++i) {
            this.values[i] = (Value)deserializer.readExpression();
        }
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        for (int i = 0; i < this.values.length; ++i) {
            if (expressionVisitor.visit(this.values[i])) continue;
            return false;
        }
        return true;
    }
}

