/*
 * Decompiled with CFR 0.152.
 */
package sisc.env;

import java.io.IOException;
import sisc.data.Value;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class LexicalEnvironment
extends Value {
    public boolean locked;
    public LexicalEnvironment parent;
    public Value[] vals;

    public LexicalEnvironment() {
        this.vals = ZV;
    }

    public LexicalEnvironment(Value[] valueArray, LexicalEnvironment lexicalEnvironment) {
        this.vals = valueArray;
        this.parent = lexicalEnvironment;
    }

    public static final void lock(LexicalEnvironment lexicalEnvironment) {
        while (lexicalEnvironment != null && !lexicalEnvironment.locked) {
            lexicalEnvironment.locked = true;
            lexicalEnvironment = lexicalEnvironment.parent;
        }
    }

    public final Value lookup(int n, int n2) {
        LexicalEnvironment lexicalEnvironment = this;
        while (n-- > 0) {
            lexicalEnvironment = lexicalEnvironment.parent;
        }
        return lexicalEnvironment.vals[n2];
    }

    public final void set(int n, int n2, Value value) {
        LexicalEnvironment lexicalEnvironment = this;
        while (n-- > 0) {
            lexicalEnvironment = lexicalEnvironment.parent;
        }
        lexicalEnvironment.vals[n2] = value;
    }

    public void display(ValueWriter valueWriter) throws IOException {
        valueWriter.append("#<").append(LexicalEnvironment.liMessage(SISCB, "environment")).append('>');
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeInt(this.vals.length);
        for (int i = 0; i < this.vals.length; ++i) {
            serializer.writeExpression(this.vals[i]);
        }
        serializer.writeBoolean(this.locked);
        serializer.writeExpression(this.parent);
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        int n = deserializer.readInt();
        this.vals = new Value[n];
        for (int i = 0; i < n; ++i) {
            this.vals[i] = (Value)deserializer.readExpression();
        }
        this.locked = deserializer.readBoolean();
        this.parent = (LexicalEnvironment)deserializer.readExpression();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        for (int i = 0; i < this.vals.length; ++i) {
            if (expressionVisitor.visit(this.vals[i])) continue;
            return false;
        }
        return expressionVisitor.visit(this.parent);
    }
}

