/*
 * Decompiled with CFR 0.152.
 */
package sisc.env;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sisc.data.Expression;
import sisc.data.NamedValue;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.env.SymbolicEnvironment;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class MemorySymEnv
extends Value
implements SymbolicEnvironment,
NamedValue {
    protected static final float EXPFACT = 1.5f;
    public Map symbolMap;
    public Map sidecars;
    public Value[] env = new Value[1];
    public SymbolicEnvironment parent;
    protected int nextFree = 0;

    public MemorySymEnv(SymbolicEnvironment symbolicEnvironment) {
        this();
        this.parent = symbolicEnvironment;
    }

    public MemorySymEnv(SymbolicEnvironment symbolicEnvironment, Symbol symbol) {
        this(symbol);
        this.parent = symbolicEnvironment;
    }

    public MemorySymEnv(Symbol symbol) {
        this();
        this.setName(symbol);
    }

    public MemorySymEnv() {
        this.symbolMap = new HashMap(1);
        this.sidecars = new HashMap(1);
    }

    public Value asValue() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set bindingKeys() {
        HashSet hashSet = new HashSet();
        Map map = this.symbolMap;
        synchronized (map) {
            hashSet.addAll(this.symbolMap.keySet());
        }
        if (this.getParent() != null) {
            hashSet.addAll(this.getParent().bindingKeys());
        }
        return hashSet;
    }

    public Map getSymbolMap() {
        return this.symbolMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymbolicEnvironment getSidecarEnvironment(Symbol symbol) {
        Map map = this.sidecars;
        synchronized (map) {
            SymbolicEnvironment symbolicEnvironment = (SymbolicEnvironment)this.sidecars.get(symbol);
            if (symbolicEnvironment == null) {
                SymbolicEnvironment symbolicEnvironment2 = this.getParent();
                SymbolicEnvironment symbolicEnvironment3 = symbolicEnvironment2 == null ? (SymbolicEnvironment)null : symbolicEnvironment2.getSidecarEnvironment(symbol);
                symbolicEnvironment = new MemorySymEnv(symbolicEnvironment3);
                this.sidecars.put(symbol, symbolicEnvironment);
            }
            return symbolicEnvironment;
        }
    }

    public void setParent(SymbolicEnvironment symbolicEnvironment) {
        this.parent = symbolicEnvironment;
        Iterator iterator = this.sidecars.keySet().iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            SymbolicEnvironment symbolicEnvironment2 = (SymbolicEnvironment)this.sidecars.get(symbol);
            symbolicEnvironment2.setParent(this.parent.getSidecarEnvironment(symbol));
        }
    }

    public SymbolicEnvironment getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expand() {
        Map map = this.symbolMap;
        synchronized (map) {
            Value[] valueArray = new Value[(int)((float)this.env.length * 1.5f + 1.0f)];
            System.arraycopy(this.env, 0, valueArray, 0, this.env.length);
            this.nextFree = this.env.length;
            this.env = valueArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim() {
        Map map = this.symbolMap;
        synchronized (map) {
            Value[] valueArray = new Value[this.nextFree];
            System.arraycopy(this.env, 0, valueArray, 0, this.nextFree);
            this.env = valueArray;
        }
    }

    public void set(int n, Value value) {
        this.env[n] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int define(Symbol symbol, Value value) {
        Map map = this.symbolMap;
        synchronized (map) {
            int n = this.getLoc(symbol);
            if (n == -1) {
                return this.store(symbol, value);
            }
            this.set(n, value);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int store(Symbol symbol, Value value) {
        Map map = this.symbolMap;
        synchronized (map) {
            if (this.nextFree >= this.env.length) {
                this.expand();
            }
            this.env[this.nextFree] = value;
            this.symbolMap.put(symbol, new Integer(this.nextFree));
            return this.nextFree++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLoc(Symbol symbol) {
        Map map = this.symbolMap;
        synchronized (map) {
            Integer n = (Integer)this.symbolMap.get(symbol);
            if (n != null) {
                return n;
            }
            if (this.getParent() == null) {
                return -1;
            }
            int n2 = this.getParent().getLoc(symbol);
            if (n2 == -1) {
                return -1;
            }
            return this.store(symbol, this.getParent().lookup(n2));
        }
    }

    public Value lookup(Symbol symbol) {
        int n = this.getLoc(symbol);
        if (n == -1) {
            return null;
        }
        return this.env[n];
    }

    public final Value lookup(int n) {
        return this.env[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undefine(Symbol symbol) {
        Map map = this.symbolMap;
        synchronized (map) {
            Integer n = (Integer)this.symbolMap.remove(symbol);
            if (n == null) {
                return;
            }
            this.env[n.intValue()] = FALSE;
        }
    }

    public void display(ValueWriter valueWriter) throws IOException {
        this.displayNamedOpaque(valueWriter, "environment");
    }

    public Iterator keys() {
        return this.symbolMap.keySet().iterator();
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeInt(this.symbolMap.size());
        Iterator iterator = this.symbolMap.keySet().iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            serializer.writeExpression(symbol);
            int n = (Integer)this.symbolMap.get(symbol);
            serializer.writeExpression(this.env[n]);
        }
        this.serializeSidecar(serializer);
        serializer.writeSymbolicEnvironment(this.getParent());
    }

    public void serializeSidecar(Serializer serializer) throws IOException {
        serializer.writeInt(this.sidecars.size());
        Iterator iterator = this.sidecars.keySet().iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            serializer.writeExpression(symbol);
            serializer.writeSymbolicEnvironment((SymbolicEnvironment)this.sidecars.get(symbol));
        }
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        int n = deserializer.readInt();
        this.env = new Value[n];
        this.symbolMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            Symbol symbol = (Symbol)deserializer.readExpression();
            this.env[i] = (Value)deserializer.readExpression();
            this.symbolMap.put(symbol, new Integer(i));
        }
        this.deserializeSidecar(deserializer);
        this.nextFree = n;
        this.parent = deserializer.readSymbolicEnvironment();
    }

    public void deserializeSidecar(Deserializer deserializer) throws IOException {
        int n = deserializer.readInt();
        for (int i = 0; i < n; ++i) {
            Expression expression = deserializer.readExpression();
            Symbol symbol = (Symbol)expression;
            this.sidecars.put(symbol, deserializer.readSymbolicEnvironment());
        }
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        if (!super.visit(expressionVisitor)) {
            return false;
        }
        Iterator iterator = this.symbolMap.keySet().iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (!expressionVisitor.visit(symbol)) {
                return false;
            }
            int n = (Integer)this.symbolMap.get(symbol);
            if (expressionVisitor.visit(this.env[n])) continue;
            return false;
        }
        return this.visitSidecar(expressionVisitor);
    }

    public boolean visitSidecar(ExpressionVisitor expressionVisitor) {
        Iterator iterator = this.sidecars.keySet().iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (expressionVisitor.visit(symbol) && expressionVisitor.visit((SymbolicEnvironment)this.sidecars.get(symbol))) continue;
            return false;
        }
        return expressionVisitor.visit(this.parent);
    }
}

