/*
 * Decompiled with CFR 0.152.
 */
package sisc.exprs;

import java.io.IOException;
import sisc.data.Expression;
import sisc.data.Immediate;
import sisc.data.Pair;
import sisc.data.Value;
import sisc.exprs.fp.OptimismUnwarrantedException;
import sisc.exprs.fp.OptimisticExpression;
import sisc.exprs.fp.OptimisticHost;
import sisc.exprs.fp.Utils;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class FillRibExp
extends Expression
implements OptimisticHost {
    static final int POS_EXP = 0;
    static final int POS_NXP = 1;
    public Expression exp;
    public Expression nxp;
    public int pos;
    public boolean lastAndRatorImmediate;

    public FillRibExp(Expression expression, int n, Expression expression2, boolean bl) {
        this.exp = expression;
        this.pos = n;
        this.nxp = expression2;
        this.lastAndRatorImmediate = bl;
    }

    public void setHosts() {
        if (!this.lastAndRatorImmediate || this.exp instanceof OptimisticExpression) {
            Utils.assertNonOptimistic(this.nxp);
        }
        Utils.linkOptimistic(this, this.exp, 0);
        Utils.linkOptimistic(this, this.nxp, 1);
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        try {
            interpreter.setVLR(this.pos, interpreter.acc);
            if (this.lastAndRatorImmediate) {
                interpreter.acc = this.exp.getValue(interpreter);
                interpreter.next(this.nxp);
            } else {
                interpreter.push(this.nxp);
                interpreter.next(this.exp);
            }
        }
        catch (OptimismUnwarrantedException optimismUnwarrantedException) {
            interpreter.nxp = this;
        }
    }

    public Value express() {
        return new Pair(FillRibExp.sym("FillRib-exp"), new Pair(this.exp.express(), this.nxp.express()));
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeExpression(this.exp);
        serializer.writeInt(this.pos);
        serializer.writeExpression(this.nxp);
        serializer.writeBoolean(this.lastAndRatorImmediate);
    }

    public FillRibExp() {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.exp = deserializer.readExpression();
        this.pos = deserializer.readInt();
        this.nxp = deserializer.readExpression();
        this.lastAndRatorImmediate = deserializer.readBoolean();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return expressionVisitor.visit(this.exp) && expressionVisitor.visit(this.nxp);
    }

    public synchronized void alter(Interpreter interpreter, int n, Expression expression) {
        switch (n) {
            case 1: {
                this.nxp = expression;
                break;
            }
            case 0: {
                this.exp = expression;
                if (!this.lastAndRatorImmediate || expression instanceof Immediate) break;
                this.lastAndRatorImmediate = false;
            }
        }
    }
}

