/*
 * Decompiled with CFR 0.152.
 */
package sisc.interpreter;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Properties;
import sisc.data.Expression;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.env.SymbolicEnvironment;
import sisc.interpreter.Context;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeException;
import sisc.ser.BufferedRandomAccessInputStream;
import sisc.ser.Library;
import sisc.ser.LibraryBinding;
import sisc.ser.LibraryBuilder;
import sisc.ser.LibraryManager;
import sisc.ser.MemoryRandomAccessInputStream;
import sisc.ser.SeekableDataInputStream;
import sisc.ser.SeekableInputStream;
import sisc.util.Util;

public class AppContext
extends Util {
    public SymbolicEnvironment symenv;
    public SymbolicEnvironment toplevel_env;
    private LibraryManager libraries;
    private Properties props;
    static /* synthetic */ Class class$sisc$interpreter$AppContext;

    public AppContext() {
        this(new Properties());
    }

    public AppContext(Properties properties) {
        this.props = properties;
        this.libraries = new LibraryManager(this);
    }

    public AppContext(SymbolicEnvironment symbolicEnvironment) {
        this();
        this.symenv = symbolicEnvironment;
        try {
            this.toplevel_env = this.lookupContextEnv(TOPLEVEL);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.toplevel_env = symbolicEnvironment;
            symbolicEnvironment.define(TOPLEVEL, this.toplevel_env.asValue());
        }
    }

    public Expression getExpression(Symbol symbol) {
        try {
            return this.libraries.getExpression(symbol);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void loadEnv(SeekableDataInputStream seekableDataInputStream) throws IOException, ClassNotFoundException {
        Library library = Library.load(this, seekableDataInputStream);
        this.libraries.addLibrary(library);
        SymbolicEnvironment symbolicEnvironment = (SymbolicEnvironment)((Object)library.getExpression(SYMENV));
        try {
            this.symenv = symbolicEnvironment;
            try {
                this.toplevel_env = this.lookupContextEnv(TOPLEVEL);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
                throw new IOException("Heap did not contain toplevel environment!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.getMessage());
        }
    }

    public void saveEnv(OutputStream outputStream, LibraryBuilder libraryBuilder) throws IOException {
        libraryBuilder.add(SYMENV, this.symenv.asValue());
        libraryBuilder.add(TOPLEVEL, this.toplevel_env.asValue());
        libraryBuilder.buildLibrary("sisc", outputStream);
    }

    public SymbolicEnvironment lookupContextEnv(Symbol symbol) {
        SymbolicEnvironment symbolicEnvironment = (SymbolicEnvironment)((Object)this.symenv.lookup(symbol));
        if (symbolicEnvironment == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return symbolicEnvironment;
    }

    public void defineContextEnv(Symbol symbol, SymbolicEnvironment symbolicEnvironment) {
        this.symenv.define(symbol, symbolicEnvironment.asValue());
    }

    public String getProperty(String string) {
        String string2 = this.props.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string2;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    public Expression resolveBinding(LibraryBinding libraryBinding) throws IOException {
        return this.libraries.resolveBinding(libraryBinding);
    }

    public LibraryBinding lookupBinding(Expression expression) throws IOException {
        return this.libraries.lookupBinding(expression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHeap(SeekableInputStream seekableInputStream) throws ClassNotFoundException {
        try {
            this.loadEnv(new SeekableDataInputStream(seekableInputStream));
        }
        catch (IOException iOException) {
            System.err.println("\n" + Util.liMessage(Util.SISCB, "errorloadingheap"));
            iOException.printStackTrace();
            return false;
        }
        Interpreter interpreter = Context.enter(this);
        try {
            try {
                File[] fileArray = File.listRoots();
                Value[] valueArray = new SchemeString[fileArray.length];
                for (int i = 0; i < fileArray.length; ++i) {
                    valueArray[i] = new SchemeString(fileArray[i].getPath());
                }
                interpreter.define(Symbol.get("fs-roots"), Util.valArrayToList(valueArray, 0, valueArray.length), Util.SISC);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            try {
                interpreter.eval("(initialize)");
            }
            catch (SchemeException schemeException) {
                System.err.println(Util.liMessage(Util.SISCB, "errorduringinitialize") + Util.simpleErrorToString(schemeException.m));
            }
            catch (IOException iOException) {
                System.err.println(Util.liMessage(Util.SISCB, "errorduringinitialize") + iOException.getMessage());
            }
        }
        finally {
            Context.exit();
        }
        return true;
    }

    public void addDefaultHeap() throws IOException {
        URL uRL = AppContext.findHeap(null);
        if (uRL == null) {
            throw new RuntimeException(Util.liMessage(Util.SISCB, "errorloadingheap"));
        }
        try {
            if (!this.addHeap(AppContext.openHeap(uRL))) {
                throw new RuntimeException(Util.liMessage(Util.SISCB, "errorloadingheap"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(Util.liMessage(Util.SISCB, "errorloadingheap"));
        }
    }

    public static SeekableInputStream openHeap(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("file")) {
            try {
                return new BufferedRandomAccessInputStream(new File(uRL.getPath()), "r", 1, 8192);
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return new MemoryRandomAccessInputStream(uRL.openStream());
    }

    public static URL findHeap(URL uRL) {
        if (uRL == null) {
            try {
                uRL = Util.makeURL(System.getProperty("sisc.heap"));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (uRL == null) {
                uRL = Util.makeURL("sisc.shp");
            }
        }
        if (AppContext.mightExist(uRL)) {
            return uRL;
        }
        Class clazz = null;
        try {
            clazz = Class.forName("sisc.boot.HeapAnchor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            Class clazz2 = clazz = class$sisc$interpreter$AppContext == null ? (class$sisc$interpreter$AppContext = AppContext.class$("sisc.interpreter.AppContext")) : class$sisc$interpreter$AppContext;
        }
        if (AppContext.mightExist(uRL = clazz.getResource("/sisc/boot/sisc.shp"))) {
            return uRL;
        }
        return null;
    }

    private static boolean mightExist(URL uRL) {
        if (uRL == null) {
            return false;
        }
        if (uRL.getProtocol().equals("file")) {
            try {
                return new File(uRL.getPath()).exists();
            }
            catch (AccessControlException accessControlException) {
                try {
                    uRL.openStream().close();
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

