/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.io;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import sisc.data.SchemeOutputPort;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.io.ReaderInputPort;
import sisc.io.SourceInputPort;
import sisc.io.WriterOutputPort;
import sisc.nativefun.IndexedFixableProcedure;
import sisc.nativefun.IndexedLibraryAdapter;

public class StringIO
extends IndexedFixableProcedure {
    static Symbol IOB = Symbol.intern("sisc.modules.io.Messages");
    protected static final int GETOUTPUTSTRING = 0;
    protected static final int OPENINPUTSTRING = 1;
    protected static final int OPENSOURCEINPUTSTRING = 2;
    protected static final int OPENOUTPUTSTRING = 3;
    protected static final int STRINGINPORTQ = 4;
    protected static final int STRINGOUTPORTQ = 5;

    public StringIO(int n) {
        super(n);
    }

    public StringIO() {
    }

    public Value apply() throws ContinuationException {
        switch (this.id) {
            case 3: {
                return new WriterOutputPort(new StringWriter(), false);
            }
        }
        StringIO.throwArgSizeException();
        return VOID;
    }

    public Value apply(Value value) throws ContinuationException {
        switch (this.id) {
            case 4: {
                return StringIO.truth(value instanceof ReaderInputPort && ((ReaderInputPort)value).getReader() instanceof StringReader);
            }
            case 5: {
                return StringIO.truth(value instanceof WriterOutputPort && ((WriterOutputPort)value).getWriter() instanceof StringWriter);
            }
            case 0: {
                SchemeOutputPort schemeOutputPort = StringIO.outport(value);
                if (!(schemeOutputPort instanceof WriterOutputPort) || !(((WriterOutputPort)schemeOutputPort).getWriter() instanceof StringWriter)) {
                    StringIO.throwPrimException(StringIO.liMessage(IOB, "outputnotastringport"));
                }
                try {
                    schemeOutputPort.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                StringWriter stringWriter = (StringWriter)((WriterOutputPort)schemeOutputPort).getWriter();
                SchemeString schemeString = new SchemeString(stringWriter.getBuffer().toString());
                stringWriter.getBuffer().setLength(0);
                return schemeString;
            }
            case 1: {
                return new ReaderInputPort(new StringReader(StringIO.string(value)));
            }
            case 2: {
                return new SourceInputPort(new StringReader(StringIO.string(value)), "<string>");
            }
        }
        StringIO.throwArgSizeException();
        return VOID;
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Value construct(Object object, int n) {
            return new StringIO(n);
        }

        public Index() {
            this.define("_get-output-string", 0);
            this.define("_open-input-string", 1);
            this.define("_open-output-string", 3);
            this.define("_open-source-input-string", 2);
            this.define("_string-input-port?", 4);
            this.define("_string-output-port?", 5);
        }
    }
}

