/*
 * Decompiled with CFR 0.152.
 */
package sisc.reader;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import sisc.compiler.CompilerConstants;
import sisc.compiler.Syntax;
import sisc.data.Box;
import sisc.data.Expression;
import sisc.data.ImmutablePair;
import sisc.data.ImmutableString;
import sisc.data.ImmutableVector;
import sisc.data.Pair;
import sisc.data.Quantity;
import sisc.data.SchemeCharacter;
import sisc.data.SchemeVector;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.exprs.AnnotatedExpr;
import sisc.io.InputPort;
import sisc.io.SourceInputPort;
import sisc.io.StreamInputPort;
import sisc.reader.CharUtil;
import sisc.reader.Lexer;
import sisc.reader.Tokens;
import sisc.util.Defaults;
import sisc.util.Util;

public class Parser
extends Util
implements Tokens {
    public static final int PRODUCE_IMMUTABLES = 1;
    public static final int PRODUCE_ANNOTATIONS = 2;
    public static final int STRICT_R5RS = 4;
    public static final int CASE_SENSITIVE = 8;
    public static final int READING_VECTOR = 16;
    public static final int PERMISSIVE_PARSING = 32;
    public boolean annotate = Defaults.EMIT_ANNOTATIONS;
    public Lexer lexer;
    static final Object DOT = new Object(){

        public String toString() {
            return ".";
        }
    };
    static final Object ENDPAIR = new Object(){

        public String toString() {
            return ")";
        }
    };
    static final Symbol SYNTAX = Symbol.get("syntax");
    static final Symbol ANNOTATION = Symbol.get("make-annotation");
    static final HashMap chars = new HashMap(8);

    public static boolean isPeculiarIdentifier(String string) {
        return string.equals("+") || string.equals("-") || string.equals("...");
    }

    public Parser(Lexer lexer) {
        this.lexer = lexer;
    }

    void warn(String string, InputPort inputPort) {
        if (inputPort instanceof SourceInputPort) {
            SourceInputPort sourceInputPort = (SourceInputPort)inputPort;
            System.err.println(Parser.warn(string, sourceInputPort.sourceFile, sourceInputPort.line, sourceInputPort.column));
        } else {
            System.err.println(Parser.warn(string));
        }
    }

    public final Value nextExpression(InputPort inputPort, int n) throws IOException {
        return this.nextExpression(inputPort, 10, n);
    }

    public final Value nextExpression(InputPort inputPort) throws IOException {
        return this.nextExpression(inputPort, 10, 1);
    }

    protected final Value nextExpression(InputPort inputPort, HashMap hashMap, int n) throws IOException {
        return (Value)this._nextExpression(inputPort, hashMap, null, n);
    }

    protected void potentialError(int n, String string, InputPort inputPort) throws IOException {
        if (this.permissiveParsing(n)) {
            if (inputPort == null) {
                System.err.println(Parser.warn(string));
            } else {
                this.warn(string, inputPort);
            }
        } else {
            throw new IOException(Parser.liMessage(SISCB, string));
        }
    }

    protected void potentialError(int n, String string, String string2, InputPort inputPort) throws IOException {
        if (this.permissiveParsing(n)) {
            if (inputPort == null) {
                System.err.println(Parser.warn(string, string2));
            } else {
                Parser.warn(Parser.liMessage(SISCB, string, string2));
            }
        } else {
            throw new IOException(Parser.liMessage(SISCB, string, string2));
        }
    }

    private Value lastValue(HashMap hashMap, Object object) {
        return (Value)(object instanceof Integer ? hashMap.get(object) : object);
    }

    public Value nextExpression(InputPort inputPort, int n, int n2) throws IOException {
        Object object = VOID;
        try {
            object = this._nextExpression(inputPort, new HashMap(), null, n, n2);
            return (Value)object;
        }
        catch (ClassCastException classCastException) {
            if (object == ENDPAIR) {
                this.potentialError(n2, "orphanedparen", inputPort);
                return this.nextExpression(inputPort, n, n2);
            }
            if (object == DOT) {
                throw new IOException(Parser.liMessage(SISCB, "unexpecteddot"));
            }
            return (Value)object;
        }
    }

    protected Object _nextExpression(InputPort inputPort, HashMap hashMap, Integer n, int n2) throws IOException {
        return this._nextExpression(inputPort, hashMap, n, 10, n2);
    }

    protected Quantity numberCheck(Object object, InputPort inputPort, int n) throws IOException {
        try {
            return (Quantity)object;
        }
        catch (ClassCastException classCastException) {
            this.potentialError(n, "badtokennotnumber", inputPort);
            return Quantity.ZERO;
        }
    }

    protected Object listSpecial(Symbol symbol, InputPort inputPort, HashMap hashMap, Integer n, int n2) throws IOException {
        Pair pair;
        boolean bl = this.produceImmutables(n2);
        Pair pair2 = bl ? new ImmutablePair(EMPTYLIST, EMPTYLIST, false) : new Pair(EMPTYLIST, EMPTYLIST);
        Pair pair3 = pair = bl ? new ImmutablePair(symbol, pair2) : new Pair(symbol, pair2);
        if (n != null) {
            hashMap.put(n, pair);
        }
        pair2.setCar(this.nextExpression(inputPort, hashMap, n2));
        if (bl) {
            ((ImmutablePair)pair2).makeImmutable();
        }
        return pair;
    }

    protected Object _nextExpression(InputPort inputPort, HashMap hashMap, Integer n, int n2, int n3) throws IOException {
        Object object;
        int n4 = -1;
        int n5 = -1;
        String string = null;
        int n6 = this.lexer.nextToken(inputPort, n2);
        block1 : switch (n6) {
            case 11: {
                return EOF;
            }
            case 6: {
                object = DOT;
                break;
            }
            case 7: {
                object = this.listSpecial(UNQUOTE, inputPort, hashMap, n, n3);
                break;
            }
            case 10: {
                object = this.listSpecial(UNQUOTE_SPLICING, inputPort, hashMap, n, n3);
                break;
            }
            case 5: {
                object = this.listSpecial(QUOTESYM, inputPort, hashMap, n, n3 & 0xFFFFFFFD);
                break;
            }
            case 9: {
                object = this.listSpecial(BACKQUOTE, inputPort, hashMap, n, n3);
                break;
            }
            case 0: {
                object = this.lexer.nval;
                break;
            }
            case 1: {
                object = new ImmutableString(this.lexer.sval);
                break;
            }
            case 2: {
                Value value;
                if (inputPort instanceof SourceInputPort) {
                    value = (SourceInputPort)inputPort;
                    n4 = value.line;
                    n5 = value.column - 1;
                    string = value.sourceFile;
                }
                if (this.annotate && this.produceAnnotations(n3) && n4 >= 0) {
                    value = new AnnotatedExpr(null, Parser.sourceAnnotations(string, n4, n5));
                    if (n != null) {
                        hashMap.put(n, value);
                        n = null;
                    }
                    ((AnnotatedExpr)value).expr = this.readList(inputPort, hashMap, n, n3);
                    return value;
                }
                return this.readList(inputPort, hashMap, n, n3);
            }
            case 4: {
                object = ENDPAIR;
                break;
            }
            case 12: {
                Symbol symbol = Symbol.intern(this.lexer.readToBreak(inputPort, Lexer.protected_literal_barrier, true, true));
                inputPort.read();
                return symbol;
            }
            case 3: {
                if (this.lexer.strictR5RS && !Parser.isPeculiarIdentifier(this.lexer.sval) && this.lexer.sval.length() >= 1 && !Character.isLetter(this.lexer.sval.charAt(0)) && !Lexer.in(this.lexer.sval.charAt(0), Lexer.special_initials)) {
                    this.potentialError(n3, "invalididentifier", this.lexer.sval, inputPort);
                }
                object = Symbol.get(this.lexer.sval, this.caseSensitive(n3));
                break;
            }
            case 8: {
                Object object2;
                Serializable serializable;
                int n7 = inputPort.read();
                char c = Character.toLowerCase((char)n7);
                switch (c) {
                    case 't': {
                        object = TRUE;
                        break block1;
                    }
                    case 'f': {
                        object = FALSE;
                        break block1;
                    }
                    case ';': {
                        this.nextExpression(inputPort);
                        object = this._nextExpression(inputPort, hashMap, n, n3);
                        break block1;
                    }
                    case '\\': {
                        n7 = inputPort.read();
                        if (Lexer.in((char)n7, Lexer.special)) {
                            object = new SchemeCharacter((char)n7);
                            break block1;
                        }
                        inputPort.pushback(n7);
                        String string2 = this.lexer.readToBreak(inputPort, Lexer.special, false, false);
                        String string3 = string2.toLowerCase();
                        SchemeCharacter schemeCharacter = CharUtil.namedConstToChar(string3);
                        try {
                            if (schemeCharacter != null) {
                                object = schemeCharacter;
                                break block1;
                            }
                            if (string2.length() == 1) {
                                object = new SchemeCharacter(string2.charAt(0));
                                break block1;
                            }
                            if (string2.charAt(0) == 'u') {
                                object = new SchemeCharacter(CharUtil.hexToChar(string3.substring(1)));
                                break block1;
                            }
                            object = new SchemeCharacter(CharUtil.octToChar(string3));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.potentialError(n3, "invalidcharconst", inputPort);
                            object = new SchemeCharacter('\u0000');
                        }
                        break block1;
                    }
                    case 'b': {
                        object = this.numberCheck(this._nextExpression(inputPort, hashMap, null, 2, n3), inputPort, n3);
                        break block1;
                    }
                    case 'o': {
                        object = this.numberCheck(this._nextExpression(inputPort, hashMap, null, 8, n3), inputPort, n3);
                        break block1;
                    }
                    case 'x': {
                        object = this.numberCheck(this._nextExpression(inputPort, hashMap, null, 16, n3), inputPort, n3);
                        break block1;
                    }
                    case 'd': {
                        object = this.numberCheck(this._nextExpression(inputPort, hashMap, null, n3), inputPort, n3);
                        break block1;
                    }
                    case '&': {
                        object = new Box();
                        if (n != null) {
                            hashMap.put(n, object);
                        }
                        ((Box)object).val = (Value)this._nextExpression(inputPort, hashMap, null, n3);
                        break block1;
                    }
                    case 'i': {
                        object = this.numberCheck(this._nextExpression(inputPort, hashMap, null, n2, n3), inputPort, n3).toInexact();
                        break block1;
                    }
                    case 'e': {
                        object = this.numberCheck(this._nextExpression(inputPort, hashMap, null, n2, n3), inputPort, n3).toExact();
                        break block1;
                    }
                    case '!': {
                        String string4 = this.lexer.readToBreak(inputPort, Lexer.special, false, false);
                        if (string4.equals("eof")) {
                            object = EOF;
                            break block1;
                        }
                        if (string4.equals("void")) {
                            object = VOID;
                            break block1;
                        }
                        if (string4.equals("+inf")) {
                            object = Quantity.POSITIVE_INFINITY;
                            break block1;
                        }
                        if (string4.equals("-inf")) {
                            object = Quantity.NEGATIVE_INFINITY;
                            break block1;
                        }
                        if (string4.equals("nan")) {
                            object = Quantity.NaN;
                            break block1;
                        }
                        this.potentialError(n3, "invalidsharpc", string4, inputPort);
                        object = VOID;
                        break block1;
                    }
                    case '%': {
                        String string5 = this.lexer.readToBreak(inputPort, Lexer.special, false, false).toLowerCase();
                        Syntax syntax = (Syntax)CompilerConstants.SYNTACTIC_TOKENS.get(string5);
                        if (syntax == null) {
                            this.potentialError(n3, "invalidsyntoken", string5, inputPort);
                            syntax = (Syntax)CompilerConstants.SYNTACTIC_TOKENS.get("unknown");
                        }
                        object = syntax;
                        break block1;
                    }
                    case '\'': {
                        object = this.listSpecial(SYNTAX, inputPort, hashMap, n, n3);
                        break block1;
                    }
                    case '@': {
                        Pair pair = (Pair)this.nextExpression(inputPort, hashMap, n3);
                        object = new AnnotatedExpr(pair.cdr(), pair.car());
                        break block1;
                    }
                    case '|': {
                        this.lexer.skipMultilineComment(inputPort);
                        return this._nextExpression(inputPort, hashMap, n, n2, n3);
                    }
                }
                Value[] valueArray = null;
                inputPort.pushback(n7);
                if (Character.isDigit((char)n7)) {
                    serializable = new Integer(Integer.parseInt(this.lexer.readToBreak(inputPort, Lexer.sharp_special, false, false)));
                    n7 = inputPort.read();
                    if (n7 == 61) {
                        object = this._nextExpression(inputPort, hashMap, (Integer)serializable, n3);
                        break;
                    }
                    if (n7 == 35) {
                        object = hashMap.get(serializable);
                        break;
                    }
                    inputPort.pushback(n7);
                    valueArray = new Value[((Integer)serializable).intValue()];
                }
                serializable = this.produceImmutables(n3) ? new ImmutableVector() : new SchemeVector();
                object = serializable;
                if (n != null) {
                    hashMap.put(n, serializable);
                }
                if ((object2 = this._nextExpression(inputPort, hashMap, n = null, n3 | 0x10)) instanceof AnnotatedExpr) {
                    object = new AnnotatedExpr((Expression)serializable, ((AnnotatedExpr)object2).annotation);
                    object2 = ((AnnotatedExpr)object2).expr;
                }
                if (object2 == null && valueArray == null) {
                    ((SchemeVector)serializable).vals = ZV;
                    break;
                }
                if (object2 instanceof Pair) {
                    if (valueArray == null) {
                        valueArray = new Value[Parser.length((Pair)object2)];
                    } else if (valueArray.length < Parser.length((Pair)object2)) {
                        this.warn("veclengthtooshort", inputPort);
                        valueArray = new Value[Parser.length((Pair)object2)];
                    }
                } else if (object2 != null) {
                    throw new IOException(Parser.liMessage(SISCB, "invalidsharp", object2.toString()));
                }
                Pair pair = (Pair)object2;
                Value value = Quantity.ZERO;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (pair != EMPTYLIST) {
                        value = pair.car();
                        pair = (Pair)pair.cdr();
                    }
                    valueArray[i] = this.lastValue(hashMap, value);
                }
                ((SchemeVector)serializable).vals = valueArray;
                break;
            }
            default: {
                this.potentialError(n3, "unknowntoken", inputPort);
                object = VOID;
            }
        }
        if (n != null) {
            hashMap.put(n, object);
        }
        return object;
    }

    private Value readAfterDot(InputPort inputPort, HashMap hashMap, int n) throws IOException {
        Value value;
        block4: {
            Object object = this._nextExpression(inputPort, hashMap, null, n);
            value = VOID;
            try {
                value = this.lastValue(hashMap, object);
            }
            catch (ClassCastException classCastException) {
                this.potentialError(n, "expectedexprincdr", inputPort);
                if (object != ENDPAIR) break block4;
                return EMPTYLIST;
            }
        }
        if (this._nextExpression(inputPort, hashMap, null, n) == ENDPAIR) {
            return value;
        }
        this.potentialError(n, "toomanyafterdot", inputPort);
        while (this._nextExpression(inputPort, hashMap, null, n) != ENDPAIR) {
        }
        return value;
    }

    public Value readList(InputPort inputPort, HashMap hashMap, Integer n, int n2) throws IOException {
        Pair pair = null;
        Pair pair2 = null;
        boolean bl = this.readingVector(n2);
        boolean bl2 = this.produceImmutables(n2);
        n2 &= 0xFFFFFFEF;
        try {
            Object object = this._nextExpression(inputPort, hashMap, null, n2);
            if (object == ENDPAIR) {
                return EMPTYLIST;
            }
            Value value = VOID;
            try {
                value = this.lastValue(hashMap, object);
            }
            catch (ClassCastException classCastException) {
                this.potentialError(n2, "expectedexprincar", inputPort);
            }
            pair2 = bl2 ? new ImmutablePair(value, EMPTYLIST, false) : new Pair(value, EMPTYLIST);
            pair = pair2;
            if (n != null) {
                hashMap.put(n, pair2);
            }
            while ((object = this._nextExpression(inputPort, hashMap, null, n2)) != ENDPAIR) {
                if (object == DOT) {
                    if (bl) {
                        this.potentialError(n2, "dotwhenreadingvector", inputPort);
                    }
                    pair2.setCdr(this.readAfterDot(inputPort, hashMap, n2));
                    if (!bl2) break;
                    ((ImmutablePair)pair2).makeImmutable();
                    break;
                }
                try {
                    value = this.lastValue(hashMap, object);
                }
                catch (ClassCastException classCastException) {
                    this.potentialError(n2, "expectedexprincar", inputPort);
                    value = VOID;
                }
                Pair pair3 = bl2 ? new ImmutablePair(value, EMPTYLIST, false) : new Pair(value, EMPTYLIST);
                pair2.setCdr(pair3);
                if (bl2) {
                    ((ImmutablePair)pair2).makeImmutable();
                }
                pair2 = pair3;
            }
            if (bl2) {
                ((ImmutablePair)pair2).makeImmutable();
            }
        }
        catch (EOFException eOFException) {
            this.potentialError(n2, "unexpectedeof", inputPort);
            return VOID;
        }
        return pair;
    }

    protected final boolean caseSensitive(int n) {
        return (n & 8) != 0;
    }

    protected final boolean produceAnnotations(int n) {
        return (n & 2) != 0;
    }

    protected final boolean produceImmutables(int n) {
        return (n & 1) != 0;
    }

    protected final boolean readingVector(int n) {
        return (n & 0x10) != 0;
    }

    protected final boolean permissiveParsing(int n) {
        return (n & 0x20) != 0;
    }

    public static void main(String[] stringArray) throws Exception {
        Value value;
        Parser parser = new Parser(new Lexer());
        StreamInputPort streamInputPort = new StreamInputPort(System.in);
        while (EOF != (value = parser.nextExpression(streamInputPort, 32))) {
            System.err.println(value);
        }
    }

    static {
        chars.put("space", new SchemeCharacter(' '));
        chars.put("backspace", new SchemeCharacter('\b'));
        chars.put("rubout", new SchemeCharacter('\u007f'));
        chars.put("page", new SchemeCharacter('\f'));
        chars.put("tab", new SchemeCharacter('\t'));
        chars.put("return", new SchemeCharacter('\r'));
        chars.put("newline", new SchemeCharacter('\n'));
        chars.put("nul", new SchemeCharacter('\u0000'));
    }
}

