/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import sisc.ser.BlockDeserializer;

public abstract class BerEncoding {
    static final int BER_MASK = 127;
    static final int BER_CONT = 128;

    public static void writeBer(long l, DataOutput dataOutput) throws IOException {
        byte[] byArray = new byte[10];
        int n = 9;
        while (l != 0L) {
            byArray[n--] = (byte)(l & 0x7FL | 0x80L);
            l >>>= 7;
        }
        byArray[9] = (byte)(byArray[9] & 0x7F);
        if (n == 9) {
            n = 8;
        }
        dataOutput.write(byArray, n + 1, byArray.length - (n + 1));
    }

    public static long readBerLong(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        long l = n & 0x7F;
        while ((n & 0x80) != 0) {
            n = dataInput.readUnsignedByte();
            l = (l << 7) + (long)(n & 0x7F);
        }
        return l;
    }

    public static short readBerShort(DataInput dataInput) throws IOException {
        return (short)BlockDeserializer.readBer(dataInput);
    }

    public static int readBer(DataInput dataInput) throws IOException {
        return (int)BerEncoding.readBerLong(dataInput);
    }
}

