/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import sisc.ser.SeekableInputStream;

public class BufferedRandomAccessInputStream
extends SeekableInputStream {
    protected RandomAccessFile raf;
    protected int stackDepth;
    protected int bufferSize;
    protected byte[][] buffer;
    protected int[][] dirtyRange;
    protected int[] eofAt;
    protected long[] offset;
    protected int bufferPtr;

    public BufferedRandomAccessInputStream(String string, String string2) throws IOException {
        this(string, string2, 4096);
    }

    public BufferedRandomAccessInputStream(String string, String string2, int n) throws IOException {
        this(string, string2, 3, n);
    }

    public BufferedRandomAccessInputStream(String string, String string2, int n, int n2) throws IOException {
        this(new File(string), string2, n, n2);
    }

    public BufferedRandomAccessInputStream(File file, String string, int n, int n2) throws IOException {
        this.raf = new RandomAccessFile(file, string);
        this.stackDepth = n;
        this.bufferSize = n2;
        this.buffer = new byte[n][n2];
        this.dirtyRange = new int[n][2];
        this.offset = new long[n];
        this.eofAt = new int[n];
        for (int i = 0; i < n; ++i) {
            this.dirtyRange[i][0] = -1;
            this.offset[i] = -1L;
            this.eofAt[i] = -1;
        }
        this.raf.seek(0L);
        this.acquire(0L);
    }

    protected void flush(int n) throws IOException {
        if (this.dirtyRange[n][0] > -1) {
            this.raf.seek(this.offset[n] + (long)this.dirtyRange[n][0]);
            this.raf.write(this.buffer[n], this.dirtyRange[n][0], this.dirtyRange[n][1] - this.dirtyRange[n][0]);
            this.dirtyRange[n][0] = -1;
            this.dirtyRange[n][0] = 0;
        }
    }

    public void flush() throws IOException {
        for (int i = 0; i < this.stackDepth; ++i) {
            if (this.dirtyRange[i][0] <= -1) continue;
            this.flush(i);
        }
    }

    protected void activate(int n, int n2) {
        if (n != 0) {
            int[] nArray = this.dirtyRange[n];
            byte[] byArray = this.buffer[n];
            long l = this.offset[n];
            int n3 = this.eofAt[n];
            for (int i = n; i > 0; --i) {
                this.dirtyRange[i] = this.dirtyRange[i - 1];
                this.buffer[i] = this.buffer[i - 1];
                this.offset[i] = this.offset[i - 1];
                this.eofAt[i] = this.eofAt[i - 1];
            }
            this.buffer[0] = byArray;
            this.offset[0] = l;
            this.eofAt[0] = n3;
            this.dirtyRange[0] = nArray;
        }
        this.bufferPtr = n2;
    }

    protected void load(long l) throws IOException {
        int n;
        long l2 = l - (long)this.bufferSize;
        long l3 = l;
        long l4 = l;
        for (n = this.stackDepth - 2; n >= 0; --n) {
            if (this.offset[n] == -1L || l2 <= this.offset[n] || l2 >= this.offset[n] + (long)this.bufferSize) continue;
            l4 = this.offset[n] + (long)this.bufferSize;
            break;
        }
        for (n = this.stackDepth - 2; n >= 0; --n) {
            if (this.offset[n] == -1L || l3 < this.offset[n] || l3 >= this.offset[n] + (long)this.bufferSize) continue;
            l4 = this.offset[n] - (long)this.bufferSize;
            break;
        }
        this.flush(this.stackDepth - 1);
        int[] nArray = this.dirtyRange[this.stackDepth - 1];
        byte[] byArray = this.buffer[this.stackDepth - 1];
        for (int i = this.stackDepth - 1; i > 0; --i) {
            this.dirtyRange[i] = this.dirtyRange[i - 1];
            this.buffer[i] = this.buffer[i - 1];
            this.offset[i] = this.offset[i - 1];
            this.eofAt[i] = this.eofAt[i - 1];
        }
        this.dirtyRange[0] = nArray;
        this.buffer[0] = byArray;
        this.dirtyRange[0][0] = -1;
        this.dirtyRange[0][1] = 0;
        this.offset[0] = -1L;
        this.raf.seek(l4);
        this.advance();
        this.bufferPtr = (int)(l - l4);
    }

    protected final void advance() throws IOException {
        this.flush(0);
        long l = this.raf.getFilePointer();
        if (this.offset[0] == -1L) {
            this.offset[0] = l;
        } else {
            this.offset[0] = this.offset[0] + (long)this.bufferSize;
            if (l != this.offset[0]) {
                this.raf.seek(this.offset[0]);
            }
        }
        int n = 0;
        int n2 = this.raf.read(this.buffer[0], 0, this.bufferSize);
        while (n2 > -1 && n < this.bufferSize) {
            n2 = this.raf.read(this.buffer[0], n += n2, this.bufferSize - n);
        }
        this.eofAt[0] = n < this.bufferSize ? n : -1;
        this.bufferPtr = 0;
    }

    protected void acquire(long l) throws IOException {
        for (int i = 0; i < this.stackDepth; ++i) {
            if (this.offset[i] == -1L || l < this.offset[i] || l >= this.offset[i] + (long)this.bufferSize) continue;
            this.activate(i, (int)(l - this.offset[i]));
            return;
        }
        this.load(l);
    }

    protected final void advancePointer(int n) throws IOException {
        this.bufferPtr += n;
        if (this.bufferPtr >= this.bufferSize) {
            this.advance();
        }
    }

    protected final void advancePointerWrite(int n) throws IOException {
        if (this.dirtyRange[0][0] == -1) {
            this.dirtyRange[0][0] = this.bufferPtr;
        }
        this.bufferPtr += n;
        int[] nArray = this.dirtyRange[0];
        nArray[1] = nArray[1] + n;
        if (this.bufferPtr >= this.bufferSize) {
            this.advance();
        }
    }

    public void close() throws IOException {
        this.flush();
        this.raf.close();
    }

    public int read() throws IOException {
        if (this.bufferPtr == this.eofAt[0]) {
            return -1;
        }
        int n = this.buffer[0][this.bufferPtr] & 0xFF;
        this.advancePointer(1);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.min(n2, Math.min(this.bufferSize - this.bufferPtr, this.eofAt[0] == -1 ? this.bufferSize : this.eofAt[0] - this.bufferPtr));
        if (n3 == 0 && n2 != 0) {
            return -1;
        }
        System.arraycopy(this.buffer[0], this.bufferPtr, byArray, n, n3);
        this.advancePointer(n3);
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int skipBytes(int n) throws IOException {
        int n2 = this.bufferSize - this.bufferPtr;
        this.advancePointer(n2);
        return n2;
    }

    public void write(int n) throws IOException {
        this.buffer[0][this.bufferPtr] = (byte)n;
        this.advancePointerWrite(1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        do {
            n3 = Math.min(n2, this.bufferSize - this.bufferPtr);
            System.arraycopy(byArray, n, this.buffer[0], this.bufferPtr, n3);
            this.advancePointerWrite(n3);
        } while ((n2 -= n3) > 0);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public long getFilePointer() throws IOException {
        return this.offset[0] + (long)this.bufferPtr;
    }

    public void seek(long l) throws IOException {
        this.acquire(l);
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        BufferedRandomAccessInputStream bufferedRandomAccessInputStream = new BufferedRandomAccessInputStream(stringArray[0], "r", 4);
        do {
            n = bufferedRandomAccessInputStream.read();
            if (bufferedRandomAccessInputStream.getFilePointer() == 10L) {
                bufferedRandomAccessInputStream.seek(13L);
            }
            if (bufferedRandomAccessInputStream.getFilePointer() != 18L) continue;
            bufferedRandomAccessInputStream.seek(12L);
        } while (n != -1);
    }
}

