/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.IOException;
import java.io.ObjectInput;
import java.math.BigDecimal;
import java.math.BigInteger;
import sisc.data.Expression;
import sisc.data.Value;
import sisc.interpreter.AppContext;
import sisc.ser.BerEncoding;
import sisc.ser.Deserializer;
import sisc.ser.LibraryBinding;

public abstract class DeserializerImpl
extends BerEncoding
implements Deserializer {
    protected AppContext ctx;
    protected ObjectInput datin;

    protected DeserializerImpl(AppContext appContext, ObjectInput objectInput) {
        this.ctx = appContext;
        this.datin = objectInput;
    }

    public Expression resolveLibraryBinding(LibraryBinding libraryBinding) throws IOException {
        return this.ctx.resolveBinding(libraryBinding);
    }

    public BigInteger readBigInteger() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return new BigInteger(byArray);
    }

    public BigDecimal readBigDecimal() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        int n = this.readInt();
        this.readFully(byArray);
        return new BigDecimal(new BigInteger(byArray), n);
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public boolean readBoolean() throws IOException {
        return this.datin.readBoolean();
    }

    public byte readByte() throws IOException {
        return (byte)DeserializerImpl.readBer(this.datin);
    }

    public char readChar() throws IOException {
        return this.datin.readChar();
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public int readInt() throws IOException {
        return DeserializerImpl.readBer(this.datin);
    }

    public long readLong() throws IOException {
        return DeserializerImpl.readBerLong(this.datin);
    }

    public short readShort() throws IOException {
        return DeserializerImpl.readBerShort(this.datin);
    }

    public String readUTF() throws IOException {
        return this.datin.readUTF();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.datin.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.datin.readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return this.datin.skipBytes(n);
    }

    public int read(byte[] byArray) throws IOException {
        return this.datin.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.datin.read(byArray, n, n2);
    }

    public int read() throws IOException {
        return this.datin.read();
    }

    public String readLine() throws IOException {
        return this.datin.readLine();
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        return this.datin.readObject();
    }

    public long skip(long l) throws IOException {
        return this.datin.skip(l);
    }

    public int available() throws IOException {
        return this.datin.available();
    }

    public void close() throws IOException {
        this.datin.close();
    }

    public Value[] readValueArray() throws IOException {
        int n = this.readInt();
        Expression[] expressionArray = new Value[n];
        this.readExpressionArray(expressionArray);
        return expressionArray;
    }

    public Expression[] readExpressionArray() throws IOException {
        int n = this.readInt();
        Expression[] expressionArray = new Expression[n];
        this.readExpressionArray(expressionArray);
        return expressionArray;
    }

    void readExpressionArray(Expression[] expressionArray) throws IOException {
        for (int i = 0; i < expressionArray.length; ++i) {
            expressionArray[i] = this.readExpression();
        }
    }
}

