/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.IOException;
import java.io.ObjectOutput;
import java.util.LinkedList;
import sisc.data.Expression;
import sisc.data.Singleton;
import sisc.data.Value;
import sisc.interpreter.AppContext;
import sisc.ser.LibraryBinding;
import sisc.ser.SerializerImpl;
import sisc.util.InternedValue;

public abstract class SLL2Serializer
extends SerializerImpl {
    private LinkedList serQueue = new LinkedList();

    protected SLL2Serializer(AppContext appContext, ObjectOutput objectOutput) throws IOException {
        super(appContext, objectOutput);
    }

    protected abstract void writeExpression(Expression var1, boolean var2) throws IOException;

    protected abstract void serializeEnd(int var1, int var2);

    public void writeExpression(Expression expression) throws IOException {
        this.writeExpressionHelper(expression, false);
    }

    public void writeInitializedExpression(Expression expression) throws IOException {
        this.writeExpressionHelper(expression, true);
    }

    private void writeExpressionHelper(Expression expression, boolean bl) throws IOException {
        if (expression == null) {
            this.writeInt(1);
            return;
        }
        this.writeExpression(expression, bl);
    }

    public void serialize(Expression expression) throws IOException {
        int n = this.serQueue.size();
        this.writeExpression(expression);
        this.serLoop(n);
    }

    protected boolean writeExpression(Expression expression, int n, int n2, boolean bl) throws IOException {
        LibraryBinding libraryBinding;
        SerJobEnd serJobEnd = new SerJobEnd(n, n2);
        boolean bl2 = expression instanceof Singleton ? this.writeExpressionSerialization(expression, serJobEnd, bl) : ((libraryBinding = this.lookupLibraryBinding(expression)) == null ? this.writeExpressionSerialization(expression, serJobEnd, bl) : this.writeLibraryReference(libraryBinding, serJobEnd, bl));
        return bl2;
    }

    private void serLoop(int n) throws IOException {
        while (this.serQueue.size() > n) {
            Object e = this.serQueue.removeFirst();
            if (e instanceof Expression) {
                this.serializeDetails((Expression)e);
                continue;
            }
            if (!(e instanceof SerJobEnd)) continue;
            SerJobEnd serJobEnd = (SerJobEnd)e;
            this.serializeEnd(serJobEnd.posi, serJobEnd.sizeStartOffset);
        }
    }

    private void serializeDetails(Expression expression) throws IOException {
        expression.serialize(this);
        expression.serializeAnnotations(this);
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public void flush() throws IOException {
        this.serLoop(0);
        super.flush();
    }

    protected void writeSeenEntryPoint(int n) throws IOException {
        this.writeInt(n + 16);
    }

    protected void writeNewEntryPointMarker(int n, Expression expression) throws IOException {
        this.writeInt(2);
        this.writeInt(n);
    }

    private boolean writeExpressionSerialization(Expression expression, SerJobEnd serJobEnd, boolean bl) throws IOException {
        if (expression instanceof Value) {
            InternedValue internedValue = InternedValue.lookupByValue((Value)expression);
            if (internedValue == null) {
                this.writeInt(0);
            } else {
                this.writeInt(3);
                this.writeInitializedExpression(internedValue.getName());
            }
        } else {
            this.writeInt(0);
        }
        this.writeClass(expression.getClass());
        if (expression instanceof Singleton) {
            expression.serialize(this);
            return true;
        }
        int n = this.serQueue.size();
        this.serQueue.addFirst(serJobEnd);
        this.serQueue.addFirst(expression);
        if (bl) {
            this.serLoop(n);
        }
        return false;
    }

    private boolean writeLibraryReference(LibraryBinding libraryBinding, SerJobEnd serJobEnd, boolean bl) throws IOException {
        this.writeInt(4);
        this.writeUTF(libraryBinding.name);
        this.writeInt(libraryBinding.epid);
        return true;
    }

    private static class SerJobEnd {
        public int posi;
        public int sizeStartOffset;

        public SerJobEnd(int n, int n2) {
            this.posi = n;
            this.sizeStartOffset = n2;
        }
    }
}

