/*
 * Decompiled with CFR 0.152.
 */
package sisc.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.HashMap;
import java.util.Map;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.ser.Deserializer;
import sisc.ser.JavaDeserializer;
import sisc.ser.JavaSerializer;
import sisc.ser.Serializer;
import sisc.util.Util;

public class InternedValue
implements Externalizable {
    private static Object sync = new Object();
    private static Map byName = new HashMap(0);
    private static Map byValue = new HashMap(0);
    private Symbol name;
    private Value value;

    public InternedValue() {
    }

    private InternedValue(Symbol symbol, Value value) {
        this.name = symbol;
        this.value = value;
    }

    public Symbol getName() {
        return this.name;
    }

    public Value getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternedValue lookupByName(Symbol symbol) {
        Object object = sync;
        synchronized (object) {
            return (InternedValue)byName.get(symbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternedValue lookupByValue(Value value) {
        Object object = sync;
        synchronized (object) {
            return (InternedValue)byValue.get(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternedValue intern(Symbol symbol, Value value) {
        InternedValue internedValue;
        Object object = sync;
        synchronized (object) {
            InternedValue internedValue2 = InternedValue.lookupByName(symbol);
            InternedValue internedValue3 = InternedValue.lookupByValue(value);
            if (internedValue2 != null && internedValue3 == null) {
                internedValue = internedValue2;
            } else if (internedValue2 == null && internedValue3 != null) {
                internedValue = internedValue3;
            } else if (internedValue2 == null && internedValue3 == null) {
                internedValue = new InternedValue(symbol, value);
                byName.put(symbol, internedValue);
                byValue.put(value, internedValue);
            } else {
                internedValue = internedValue2 == internedValue3 ? internedValue2 : null;
            }
        }
        return internedValue;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Serializer serializer = JavaSerializer.create(objectOutput);
        serializer.writeInitializedExpression(this.name);
        serializer.writeClass(this.value.getClass());
        this.value.serialize(serializer);
    }

    public static Value deserResolve(Symbol symbol, Class clazz) throws IOException {
        Value value;
        try {
            value = (Value)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            throw new IOException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new IOException(illegalAccessException.getMessage());
        }
        value = InternedValue.intern(symbol, value).getValue();
        if (value.getClass() != clazz) {
            throw new IOException(Util.liMessage(Util.SISCB, "interntypemismatch", new Object[]{symbol, value.getClass(), clazz.getClass()}));
        }
        return value;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        Deserializer deserializer = JavaDeserializer.create(objectInput);
        this.name = (Symbol)deserializer.readInitializedExpression();
        Class clazz = deserializer.readClass();
        this.value = InternedValue.deserResolve(this.name, clazz);
        this.value.deserialize(deserializer);
    }

    public Object readResolve() throws ObjectStreamException {
        return this.value;
    }
}

