/*
 * Decompiled with CFR 0.152.
 */
package sisc.env;

import java.io.IOException;
import sisc.data.SchemeBoolean;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.env.SchemeParameter;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.ValueWriter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;

public class ConfigParameter
extends SchemeParameter {
    private String paramName;

    public ConfigParameter() {
    }

    public ConfigParameter(String string, Value value) {
        super(value);
        this.paramName = string;
    }

    public Value getValue(Interpreter interpreter) throws ContinuationException {
        Value value = (Value)interpreter.dynenv.parameters.get(this);
        if (value != null) {
            return value;
        }
        String string = interpreter.dynenv.ctx.getProperty("sisc." + this.paramName);
        if (string == null) {
            return this.def;
        }
        if (this.def instanceof SchemeBoolean) {
            value = ConfigParameter.truth(string.equals("true"));
        } else if (this.def instanceof SchemeString) {
            value = new SchemeString(string);
        } else if (this.def instanceof Symbol) {
            value = Symbol.get(string);
        } else {
            try {
                value = ConfigParameter.read(string);
            }
            catch (IOException iOException) {
                ConfigParameter.error(interpreter, ConfigParameter.liMessage(SISCB, "configparammalformed", this.paramName));
            }
        }
        return value;
    }

    public void display(ValueWriter valueWriter) throws IOException {
        valueWriter.append("#<").append(ConfigParameter.liMessage(SISCB, "configparameter"));
        valueWriter.append(" ").append(this.paramName).append('>');
    }

    public void serialize(Serializer serializer) throws IOException {
        super.serialize(serializer);
        serializer.writeUTF(this.paramName);
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        super.deserialize(deserializer);
        this.paramName = deserializer.readUTF();
    }
}

