/*
 * Decompiled with CFR 0.152.
 */
package sisc.exprs;

import java.io.IOException;
import sisc.data.Expression;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.env.SymbolicEnvironment;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class DefineEval
extends Expression {
    public Symbol lhs;
    public SymbolicEnvironment env;

    public DefineEval(Symbol symbol, SymbolicEnvironment symbolicEnvironment) {
        this.lhs = symbol;
        this.env = symbolicEnvironment;
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        Value value = interpreter.acc;
        DefineEval.updateName(value, this.lhs);
        this.env.define(this.lhs, value);
        interpreter.acc = VOID;
        interpreter.nxp = null;
    }

    public Value express() {
        return DefineEval.list(DefineEval.sym("Define-eval"), this.lhs);
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeExpression(this.lhs);
        serializer.writeSymbolicEnvironment(this.env);
    }

    public DefineEval() {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.lhs = (Symbol)deserializer.readExpression();
        this.env = deserializer.readSymbolicEnvironment();
    }

    public boolean equals(Object object) {
        return object instanceof DefineEval && this.lhs.equals(((DefineEval)object).lhs);
    }

    public int hashCode() {
        return this.lhs.hashCode() ^ this.env.hashCode();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return expressionVisitor.visit(this.lhs) && expressionVisitor.visit(this.env);
    }
}

