/*
 * Decompiled with CFR 0.152.
 */
package sisc.exprs;

import java.io.IOException;
import sisc.data.Expression;
import sisc.data.Immediate;
import sisc.data.Value;
import sisc.exprs.fp.OptimismUnwarrantedException;
import sisc.exprs.fp.OptimisticExpression;
import sisc.exprs.fp.OptimisticHost;
import sisc.exprs.fp.Utils;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitor;

public class EvalExp
extends Expression
implements OptimisticHost {
    public static final int POS_PRE = 0;
    public static final int POS_POST = 1;
    public Expression pre;
    public Expression post;
    public boolean preImmediate;

    public EvalExp(Expression expression, Expression expression2, boolean bl) {
        this.pre = expression;
        this.post = expression2;
        this.preImmediate = bl;
    }

    public void setHosts() {
        if (!this.preImmediate || this.pre instanceof OptimisticExpression) {
            Utils.assertNonOptimistic(this.post);
        }
        Utils.linkOptimistic(this, this.pre, 0);
        Utils.linkOptimistic(this, this.post, 1);
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        try {
            if (this.preImmediate) {
                interpreter.acc = this.pre.getValue(interpreter);
                interpreter.next(this.post);
            } else {
                interpreter.push(this.post);
                interpreter.next(this.pre);
            }
        }
        catch (OptimismUnwarrantedException optimismUnwarrantedException) {
            interpreter.nxp = this;
        }
    }

    public Value express() {
        return EvalExp.list(EvalExp.sym("Eval-exp"), this.pre.express(), this.post.express());
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeExpression(this.pre);
        serializer.writeExpression(this.post);
        serializer.writeBoolean(this.preImmediate);
    }

    public EvalExp() {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.pre = deserializer.readExpression();
        this.post = deserializer.readExpression();
        this.preImmediate = deserializer.readBoolean();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return expressionVisitor.visit(this.pre) && expressionVisitor.visit(this.post);
    }

    public synchronized void alter(Interpreter interpreter, int n, Expression expression) {
        switch (n) {
            case 0: {
                this.pre = expression;
                if (!this.preImmediate || expression instanceof Immediate) break;
                this.preImmediate = false;
                break;
            }
            case 1: {
                this.post = expression;
            }
        }
    }
}

