/*
 * Decompiled with CFR 0.152.
 */
package sisc.exprs;

import java.io.IOException;
import sisc.data.Box;
import sisc.data.Expression;
import sisc.data.Pair;
import sisc.data.Value;
import sisc.env.LexicalUtils;
import sisc.exprs.AppExp;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;

public class LetrecExp
extends AppExp {
    int lcount;
    int[] localIndices;
    int[] lexicalIndices;

    public LetrecExp(Expression expression, Expression[] expressionArray, Expression expression2, int[] nArray, int[] nArray2, boolean bl) {
        super(expression, expressionArray, expression2, bl);
        this.localIndices = nArray;
        this.lexicalIndices = nArray2;
        this.lcount = nArray.length + nArray2.length;
    }

    public void eval(Interpreter interpreter) throws ContinuationException {
        interpreter.env = LexicalUtils.fixLexicals(interpreter, this.lcount, this.localIndices, this.lexicalIndices);
        interpreter.lcl = interpreter.createValues(this.rands.length);
        for (int i = this.rands.length - 1; i >= 0; --i) {
            interpreter.lcl[i] = new Box(VOID);
        }
        super.eval(interpreter);
    }

    public Value express() {
        Pair pair = LexicalUtils.intArrayToList(this.localIndices);
        Pair pair2 = LexicalUtils.intArrayToList(this.lexicalIndices);
        Pair pair3 = EMPTYLIST;
        for (int i = this.rands.length - 1; i >= 0; --i) {
            pair3 = new Pair(this.rands[i] == null ? FALSE : this.rands[i].express(), pair3);
        }
        pair3 = new Pair(pair, new Pair(pair2, new Pair(this.nxp.express(), pair3)));
        return new Pair(LetrecExp.sym("Letrec-exp"), pair3);
    }

    public LetrecExp() {
    }

    public void serialize(Serializer serializer) throws IOException {
        super.serialize(serializer);
        LexicalUtils.writeIntArray(serializer, this.localIndices);
        LexicalUtils.writeIntArray(serializer, this.lexicalIndices);
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        super.deserialize(deserializer);
        this.localIndices = LexicalUtils.readIntArray(deserializer);
        this.lexicalIndices = LexicalUtils.readIntArray(deserializer);
        this.lcount = (this.localIndices == null ? 0 : this.localIndices.length) + (this.lexicalIndices == null ? 0 : this.lexicalIndices.length);
    }
}

