/*
 * Decompiled with CFR 0.152.
 */
package sisc.interpreter;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Random;
import java.util.Stack;
import sisc.data.SchemeThread;
import sisc.env.DynamicEnvironment;
import sisc.interpreter.AppContext;
import sisc.interpreter.Interpreter;
import sisc.util.Util;

public class ThreadContext
extends Util {
    protected Stack states = new Stack();
    protected Random r = new Random();
    public WeakReference hostThread;
    public boolean interrupt = false;
    public long unicityMajor = this.genUnicityMajor();
    public char unicityMinor = '\u0000';

    protected long genUnicityMajor() {
        return System.currentTimeMillis() + (long)(this.r.nextInt() & 0xFFFF) * 311040000000L;
    }

    public long nextUnique() {
        this.unicityMinor = (char)(this.unicityMinor + '\u0001');
        if (this.unicityMinor == '\u0000') {
            this.unicityMajor = this.genUnicityMajor();
        }
        return this.unicityMajor + (long)this.unicityMinor * 31104000000L;
    }

    public Interpreter currentInterpreter() {
        return this.states.empty() ? null : ((State)this.states.peek()).interpreter;
    }

    public Interpreter currentInterpreter(AppContext appContext) {
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            Interpreter interpreter = ((State)iterator.next()).interpreter;
            if (interpreter.dynenv.ctx != appContext) continue;
            return interpreter;
        }
        return null;
    }

    protected void pushState(State state) {
        this.states.push(state);
    }

    protected State popState() {
        return (State)this.states.pop();
    }

    public Thread nativeThread() {
        if (this.hostThread == null) {
            return null;
        }
        SchemeThread schemeThread = (SchemeThread)this.hostThread.get();
        if (schemeThread == null) {
            return null;
        }
        return schemeThread.thread;
    }

    public void setHostThread(DynamicEnvironment dynamicEnvironment, Thread thread) {
        if (this.nativeThread() != thread) {
            SchemeThread schemeThread = new SchemeThread(dynamicEnvironment, null);
            schemeThread.thread = thread;
            this.hostThread = new WeakReference<SchemeThread>(schemeThread);
        }
    }

    public static class State {
        public final Interpreter interpreter;
        public final ClassLoader classLoader;

        public State(Interpreter interpreter, ClassLoader classLoader) {
            this.interpreter = interpreter;
            this.classLoader = classLoader;
        }
    }
}

