/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import sisc.data.Expression;
import sisc.data.Pair;
import sisc.data.Quantity;
import sisc.data.SchemeCharacter;
import sisc.data.SchemeInputPort;
import sisc.data.SchemeOutputPort;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.Context;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeException;
import sisc.io.BinaryInputPort;
import sisc.io.BinaryOutputPort;
import sisc.io.Charset;
import sisc.io.InputPort;
import sisc.io.OutputPort;
import sisc.io.Port;
import sisc.io.PortValueWriter;
import sisc.io.ReaderInputPort;
import sisc.io.SharedValueWriter;
import sisc.io.SourceInputPort;
import sisc.io.WriterOutputPort;
import sisc.nativefun.IndexedLibraryAdapter;
import sisc.nativefun.IndexedProcedure;
import sisc.util.Util;

public class IO
extends IndexedProcedure {
    static Symbol IOB = Symbol.intern("sisc.modules.io.Messages");
    protected static final int ABSPATHQ = 0;
    protected static final int CHARREADY = 3;
    protected static final int CLOSEINPUTPORT = 4;
    protected static final int CLOSEOUTPUTPORT = 5;
    protected static final int DISPLAY = 8;
    protected static final int FILEEXISTSQ = 9;
    protected static final int FINDRESOURCE = 6;
    protected static final int FINDRESOURCES = 2;
    protected static final int FLUSHOUTPUTPORT = 10;
    protected static final int INPORTQ = 12;
    protected static final int INPORTLOCATION = 13;
    protected static final int LOAD = 14;
    protected static final int LOADEXPANDED = 24;
    protected static final int MAKEPATH = 15;
    protected static final int NORMALIZEURL = 16;
    protected static final int OPENINPUTFILE = 17;
    protected static final int OPENOUTPUTFILE = 19;
    protected static final int OPENSOURCEINPUTFILE = 20;
    protected static final int OUTPORTQ = 22;
    protected static final int PEEKBYTE = 30;
    protected static final int PEEKCHAR = 23;
    protected static final int PORTQ = 27;
    protected static final int READ = 21;
    protected static final int READBYTE = 29;
    protected static final int READCHAR = 18;
    protected static final int READSTRING = 25;
    protected static final int READCODE = 11;
    protected static final int WRITE = 1;
    protected static final int WRITEBYTE = 28;
    protected static final int WRITECHAR = 7;
    protected static final int WRITESTRING = 26;

    public IO(int n) {
        super(n);
    }

    public IO() {
    }

    static void throwIOException(Interpreter interpreter, String string, IOException iOException) throws ContinuationException {
        if (interpreter.acc == null) {
            IO.error(interpreter, string, IO.list(new Pair(JEXCEPTION, IO.javaWrap(iOException))));
        } else if (interpreter.acc.getName() != null) {
            IO.error(interpreter, (Value)interpreter.acc.getName(), string, IO.list(new Pair(JEXCEPTION, IO.javaWrap(iOException))));
        } else {
            IO.error(interpreter, string, IO.list(new Pair(JEXCEPTION, IO.javaWrap(iOException))));
        }
    }

    private static Value readChar(Interpreter interpreter, InputPort inputPort) throws ContinuationException {
        if (inputPort instanceof BinaryInputPort) {
            System.err.println(Util.warn("charoponbinport", ((Value)((Object)inputPort)).synopsis()));
        }
        try {
            int n = inputPort.read();
            return new SchemeCharacter((char)n);
        }
        catch (EOFException eOFException) {
            return EOF;
        }
        catch (IOException iOException) {
            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorreading", inputPort.toString(), iOException.getMessage()), iOException);
            return null;
        }
    }

    private static Value readByte(Interpreter interpreter, InputPort inputPort) throws ContinuationException {
        try {
            int n = inputPort.read();
            return Quantity.valueOf(n);
        }
        catch (EOFException eOFException) {
            return EOF;
        }
        catch (IOException iOException) {
            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorreading", inputPort.toString(), iOException.getMessage()), iOException);
            return null;
        }
    }

    private static Value read(Interpreter interpreter, InputPort inputPort, int n) throws ContinuationException {
        if (inputPort instanceof BinaryInputPort) {
            System.err.println(Util.warn("charoponbinport", ((Value)((Object)inputPort)).synopsis()));
        }
        try {
            return interpreter.dynenv.parser.nextExpression(inputPort, n);
        }
        catch (EOFException eOFException) {
            return EOF;
        }
        catch (IOException iOException) {
            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorreading", inputPort.toString(), iOException.getMessage()), iOException);
            return null;
        }
    }

    public static Value read(Interpreter interpreter, InputPort inputPort) throws ContinuationException {
        return IO.read(interpreter, inputPort, (interpreter.dynenv.caseSensitive ? 8 : 0) | (interpreter.dynenv.permissiveParsing ? 32 : 0));
    }

    public static Value readCode(Interpreter interpreter, InputPort inputPort) throws ContinuationException {
        return IO.read(interpreter, inputPort, 3 | (interpreter.dynenv.caseSensitive ? 8 : 0) | (interpreter.dynenv.permissiveParsing ? 32 : 0));
    }

    public Value displayOrWrite(Interpreter interpreter, OutputPort outputPort, Value value, boolean bl) throws ContinuationException {
        try {
            PortValueWriter portValueWriter;
            PortValueWriter portValueWriter2 = portValueWriter = interpreter.dynenv.printShared ? new SharedValueWriter(outputPort, interpreter.dynenv.vectorLengthPrefixing, interpreter.dynenv.caseSensitive) : new PortValueWriter(outputPort, interpreter.dynenv.vectorLengthPrefixing, interpreter.dynenv.caseSensitive);
            if (bl) {
                portValueWriter.display(value);
            } else {
                portValueWriter.write(value);
            }
        }
        catch (IOException iOException) {
            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorwriting", outputPort.toString(), iOException.getMessage()), iOException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return VOID;
    }

    public static URL urlClean(URL uRL) {
        if (uRL.getProtocol().equals("file") && (uRL.getRef() != null || uRL.getQuery() != null)) {
            StringBuffer stringBuffer = new StringBuffer(uRL.getProtocol());
            stringBuffer.append(':');
            stringBuffer.append(uRL.getPath());
            if (uRL.getRef() != null) {
                stringBuffer.append("%23");
                stringBuffer.append(URLEncoder.encode(uRL.getRef()));
            }
            if (uRL.getQuery() != null) {
                stringBuffer.append("%3F");
                stringBuffer.append(URLEncoder.encode(uRL.getQuery()));
            }
            try {
                uRL = new URL(stringBuffer.toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return uRL;
    }

    public static SchemeInputPort openCharInFile(Interpreter interpreter, URL uRL, Charset charset) throws ContinuationException {
        try {
            return new SourceInputPort(new BufferedReader(charset.newInputStreamReader(IO.getURLInputStream(uRL))), uRL.toString());
        }
        catch (IOException iOException) {
            IO.throwIOException(interpreter, IO.liMessage(IOB, "erroropening", uRL.toString()), iOException);
            return null;
        }
    }

    public static SchemeOutputPort openCharOutFile(Interpreter interpreter, URL uRL, Charset charset, boolean bl) throws ContinuationException {
        try {
            return new WriterOutputPort(IO.getURLOutputStream(uRL), charset, bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            IO.throwIOException(interpreter, IO.liMessage(IOB, "erroropening", uRL.toString()), iOException);
            return null;
        }
    }

    public static InputStream getURLInputStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(false);
        return uRLConnection.getInputStream();
    }

    public static OutputStream getURLOutputStream(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("file")) {
            return new FileOutputStream(uRL.getPath());
        }
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(false);
        uRLConnection.setDoOutput(true);
        return uRLConnection.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value doApply(Interpreter interpreter) throws ContinuationException {
        switch (interpreter.vlr.length) {
            case 0: {
                switch (this.id) {
                    case 3: {
                        try {
                            return IO.truth(interpreter.dynenv.getCurrentInPort().ready());
                        }
                        catch (IOException iOException) {
                            return FALSE;
                        }
                    }
                    case 10: {
                        try {
                            interpreter.dynenv.getCurrentOutPort().flush();
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorflushing", interpreter.dynenv.out.toString()), iOException);
                        }
                        return VOID;
                    }
                    case 23: {
                        Value value = IO.readChar(interpreter, interpreter.dynenv.getCurrentInPort());
                        if (value instanceof SchemeCharacter) {
                            interpreter.dynenv.getCurrentInPort().pushback(((SchemeCharacter)value).c);
                        }
                        return value;
                    }
                    case 30: {
                        Value value = IO.readByte(interpreter, interpreter.dynenv.getCurrentInPort());
                        if (value instanceof Quantity) {
                            interpreter.dynenv.getCurrentInPort().pushback(((Quantity)value).indexValue());
                        }
                        return value;
                    }
                    case 21: {
                        return IO.read(interpreter, interpreter.dynenv.getCurrentInPort());
                    }
                    case 29: {
                        return IO.readByte(interpreter, interpreter.dynenv.getCurrentInPort());
                    }
                    case 18: {
                        return IO.readChar(interpreter, interpreter.dynenv.getCurrentInPort());
                    }
                    case 11: {
                        return IO.readCode(interpreter, interpreter.dynenv.getCurrentInPort());
                    }
                }
                IO.throwArgSizeException();
            }
            case 1: {
                switch (this.id) {
                    case 27: {
                        return IO.truth(interpreter.vlr[0] instanceof Port);
                    }
                    case 12: {
                        return IO.truth(interpreter.vlr[0] instanceof InputPort);
                    }
                    case 22: {
                        return IO.truth(interpreter.vlr[0] instanceof OutputPort);
                    }
                    case 3: {
                        SchemeInputPort schemeInputPort = IO.inport(interpreter.vlr[0]);
                        try {
                            return IO.truth(schemeInputPort.ready());
                        }
                        catch (IOException iOException) {
                            return FALSE;
                        }
                    }
                    case 8: {
                        return this.displayOrWrite(interpreter, interpreter.dynenv.getCurrentOutPort(), interpreter.vlr[0], true);
                    }
                    case 1: {
                        return this.displayOrWrite(interpreter, interpreter.dynenv.getCurrentOutPort(), interpreter.vlr[0], false);
                    }
                    case 30: {
                        SchemeInputPort schemeInputPort = IO.inport(interpreter.vlr[0]);
                        Value value = IO.readByte(interpreter, schemeInputPort);
                        if (value instanceof Quantity) {
                            schemeInputPort.pushback(((Quantity)value).indexValue());
                        }
                        return value;
                    }
                    case 23: {
                        SchemeInputPort schemeInputPort = IO.inport(interpreter.vlr[0]);
                        Value value = IO.readChar(interpreter, schemeInputPort);
                        if (value instanceof SchemeCharacter) {
                            schemeInputPort.pushback(((SchemeCharacter)value).c);
                        }
                        return value;
                    }
                    case 21: {
                        SchemeInputPort schemeInputPort = IO.inport(interpreter.vlr[0]);
                        return IO.read(interpreter, schemeInputPort);
                    }
                    case 29: {
                        SchemeInputPort schemeInputPort = IO.inport(interpreter.vlr[0]);
                        return IO.readByte(interpreter, schemeInputPort);
                    }
                    case 18: {
                        SchemeInputPort schemeInputPort = IO.inport(interpreter.vlr[0]);
                        return IO.readChar(interpreter, schemeInputPort);
                    }
                    case 11: {
                        SchemeInputPort schemeInputPort = IO.inport(interpreter.vlr[0]);
                        return IO.readCode(interpreter, schemeInputPort);
                    }
                    case 20: {
                        URL uRL = IO.url(interpreter.vlr[0]);
                        try {
                            return new SourceInputPort(new BufferedReader(interpreter.dynenv.characterSet.newInputStreamReader(IO.getURLInputStream(uRL))), uRL.toString());
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "erroropening", uRL.toString()), iOException);
                        }
                    }
                    case 17: {
                        URL uRL = IO.url(interpreter.vlr[0]);
                        return IO.openCharInFile(interpreter, uRL, interpreter.dynenv.characterSet);
                    }
                    case 19: {
                        URL uRL = IO.url(interpreter.vlr[0]);
                        return IO.openCharOutFile(interpreter, uRL, interpreter.dynenv.characterSet, false);
                    }
                    case 10: {
                        SchemeOutputPort schemeOutputPort = IO.outport(interpreter.vlr[0]);
                        try {
                            schemeOutputPort.flush();
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorflushing", ((Object)schemeOutputPort).toString()), iOException);
                        }
                        return VOID;
                    }
                    case 4: {
                        SchemeInputPort schemeInputPort = IO.inport(interpreter.vlr[0]);
                        try {
                            if (schemeInputPort != interpreter.dynenv.in) {
                                schemeInputPort.close();
                            }
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorclosing", ((Object)schemeInputPort).toString()), iOException);
                        }
                        return VOID;
                    }
                    case 5: {
                        SchemeOutputPort schemeOutputPort = IO.outport(interpreter.vlr[0]);
                        try {
                            if (schemeOutputPort != interpreter.dynenv.out) {
                                schemeOutputPort.close();
                            }
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorclosing", ((Object)schemeOutputPort).toString()), iOException);
                        }
                        return VOID;
                    }
                    case 13: {
                        SchemeInputPort schemeInputPort = IO.inport(interpreter.vlr[0]);
                        if (schemeInputPort instanceof SourceInputPort) {
                            SourceInputPort sourceInputPort = (SourceInputPort)schemeInputPort;
                            return IO.sourceAnnotations(sourceInputPort.sourceFile, sourceInputPort.line, sourceInputPort.column);
                        }
                        return FALSE;
                    }
                    case 14: {
                        Object object;
                        SourceInputPort sourceInputPort = null;
                        URL uRL = IO.url(interpreter.vlr[0]);
                        try {
                            object = uRL.openConnection();
                            ((URLConnection)object).setDoInput(true);
                            ((URLConnection)object).setDoOutput(false);
                            sourceInputPort = new SourceInputPort(((URLConnection)object).getInputStream(), Util.charsetFromString(((URLConnection)object).getContentEncoding()), uRL.toString());
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "erroropening", uRL.toString()), iOException);
                        }
                        object = Context.enter(interpreter.dynenv);
                        try {
                            Value value = null;
                            do {
                                int n = sourceInputPort.line;
                                int n2 = sourceInputPort.column;
                                value = IO.readCode(interpreter, sourceInputPort);
                                if (value == EOF) continue;
                                try {
                                    ((Interpreter)object).eval(value, interpreter.tpl);
                                }
                                catch (SchemeException schemeException) {
                                    IO.throwNestedPrimException(IO.liMessage(IOB, "evalat", sourceInputPort.sourceFile, n, n2), schemeException);
                                }
                            } while (value != EOF);
                        }
                        finally {
                            Context.exit();
                        }
                        return VOID;
                    }
                    case 24: {
                        SourceInputPort sourceInputPort = null;
                        URL uRL = IO.url(interpreter.vlr[0]);
                        try {
                            URLConnection uRLConnection = uRL.openConnection();
                            uRLConnection.setDoInput(true);
                            uRLConnection.setDoOutput(false);
                            sourceInputPort = new SourceInputPort(uRLConnection.getInputStream(), Util.charsetFromString(uRLConnection.getContentEncoding()), uRL.toString());
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "erroropening", uRL.toString()), iOException);
                        }
                        Interpreter interpreter2 = Context.enter(interpreter.dynenv);
                        try {
                            Value value = null;
                            do {
                                int n = sourceInputPort.line;
                                int n3 = sourceInputPort.column;
                                value = IO.readCode(interpreter, sourceInputPort);
                                if (value == EOF) continue;
                                try {
                                    Expression expression = interpreter2.compile(value);
                                    interpreter2.interpret(expression);
                                }
                                catch (SchemeException schemeException) {
                                    IO.throwNestedPrimException(IO.liMessage(IOB, "evalat", sourceInputPort.sourceFile, n, n3), schemeException);
                                }
                            } while (value != EOF);
                        }
                        finally {
                            Context.exit();
                        }
                        return VOID;
                    }
                    case 7: {
                        try {
                            interpreter.dynenv.getCurrentOutPort().write(IO.character(interpreter.vlr[0]));
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorwriting", interpreter.dynenv.out.toString(), iOException.getMessage()), iOException);
                        }
                        return VOID;
                    }
                    case 28: {
                        try {
                            ((BinaryOutputPort)((Object)interpreter.dynenv.getCurrentOutPort())).write(IO.num(interpreter.vlr[0]).indexValue());
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorwriting", interpreter.dynenv.out.toString(), iOException.getMessage()), iOException);
                        }
                        return VOID;
                    }
                    case 9: {
                        try {
                            IO.url(interpreter.vlr[0]).openConnection().getInputStream().close();
                            return TRUE;
                        }
                        catch (IOException iOException) {
                            return FALSE;
                        }
                    }
                    case 6: {
                        URL uRL = Util.currentClassLoader().getResource(IO.string(interpreter.vlr[0]));
                        if (uRL == null) {
                            return FALSE;
                        }
                        return new SchemeString(uRL.toString());
                    }
                    case 2: {
                        Enumeration<URL> enumeration;
                        try {
                            enumeration = Util.currentClassLoader().getResources(IO.string(interpreter.vlr[0]));
                        }
                        catch (IOException iOException) {
                            return EMPTYLIST;
                        }
                        if (!enumeration.hasMoreElements()) {
                            return EMPTYLIST;
                        }
                        Pair pair = new Pair();
                        while (true) {
                            pair.setCar(new SchemeString((String)((Object)enumeration.nextElement())));
                            if (!enumeration.hasMoreElements()) break;
                            pair.setCdr(new Pair());
                            pair = (Pair)pair.cdr();
                        }
                        return pair;
                    }
                    case 0: {
                        String string = IO.string(interpreter.vlr[0]);
                        if (string.startsWith("file:")) {
                            string = string.substring(5);
                        }
                        File file = new File(string);
                        return IO.truth(file.isAbsolute());
                    }
                    case 16: {
                        URL uRL = IO.urlClean(IO.url(interpreter.vlr[0]));
                        return new SchemeString(uRL.toString());
                    }
                }
                IO.throwArgSizeException();
            }
            case 2: {
                switch (this.id) {
                    case 7: {
                        SchemeOutputPort schemeOutputPort = IO.outport(interpreter.vlr[1]);
                        try {
                            schemeOutputPort.write(IO.character(interpreter.vlr[0]));
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorwriting", ((Object)schemeOutputPort).toString(), iOException.getMessage()), iOException);
                        }
                        return VOID;
                    }
                    case 28: {
                        BinaryOutputPort binaryOutputPort = (BinaryOutputPort)((Object)IO.outport(interpreter.vlr[1]));
                        try {
                            binaryOutputPort.write(IO.num(interpreter.vlr[0]).indexValue());
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, IO.liMessage(IOB, "errorwriting", binaryOutputPort.toString(), iOException.getMessage()), iOException);
                        }
                        return VOID;
                    }
                    case 8: {
                        return this.displayOrWrite(interpreter, IO.outport(interpreter.vlr[1]), interpreter.vlr[0], true);
                    }
                    case 1: {
                        return this.displayOrWrite(interpreter, IO.outport(interpreter.vlr[1]), interpreter.vlr[0], false);
                    }
                    case 17: {
                        URL uRL = IO.url(interpreter.vlr[0]);
                        return IO.openCharInFile(interpreter, uRL, Util.charsetFromString(IO.string(interpreter.vlr[1])));
                    }
                    case 19: {
                        URL uRL = IO.url(interpreter.vlr[0]);
                        boolean bl = false;
                        Charset charset = interpreter.dynenv.characterSet;
                        if (interpreter.vlr[1] instanceof SchemeString) {
                            charset = Util.charsetFromString(IO.string(interpreter.vlr[1]));
                        } else {
                            bl = IO.truth(interpreter.vlr[1]);
                        }
                        return IO.openCharOutFile(interpreter, uRL, charset, bl);
                    }
                    case 16: {
                        return new SchemeString(IO.urlClean(IO.url(interpreter.vlr[0], interpreter.vlr[1])).toString());
                    }
                }
                IO.throwArgSizeException();
            }
            case 3: {
                switch (this.id) {
                    case 25: {
                        try {
                            return Quantity.valueOf(IO.str(interpreter.vlr[0]).readFromReader(((ReaderInputPort)interpreter.dynenv.in).getReader(), IO.num(interpreter.vlr[1]).intValue(), IO.num(interpreter.vlr[2]).intValue()));
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, iOException.getMessage(), iOException);
                            return VOID;
                        }
                    }
                    case 26: {
                        try {
                            IO.str(interpreter.vlr[0]).writeToWriter(((WriterOutputPort)interpreter.dynenv.out).getWriter(), IO.num(interpreter.vlr[1]).intValue(), IO.num(interpreter.vlr[2]).intValue());
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, iOException.getMessage(), iOException);
                        }
                        return VOID;
                    }
                    case 19: {
                        URL uRL = IO.url(interpreter.vlr[0]);
                        return IO.openCharOutFile(interpreter, uRL, Util.charsetFromString(IO.string(interpreter.vlr[1])), IO.truth(interpreter.vlr[2]));
                    }
                }
                IO.throwArgSizeException();
            }
            case 4: {
                switch (this.id) {
                    case 25: {
                        try {
                            return Quantity.valueOf(IO.str(interpreter.vlr[0]).readFromReader(((ReaderInputPort)interpreter.vlr[3]).getReader(), IO.num(interpreter.vlr[1]).intValue(), IO.num(interpreter.vlr[2]).intValue()));
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, iOException.getMessage(), iOException);
                            return VOID;
                        }
                    }
                    case 26: {
                        try {
                            IO.str(interpreter.vlr[0]).writeToWriter(((WriterOutputPort)interpreter.vlr[3]).getWriter(), IO.num(interpreter.vlr[1]).intValue(), IO.num(interpreter.vlr[2]).intValue());
                        }
                        catch (IOException iOException) {
                            IO.throwIOException(interpreter, iOException.getMessage(), iOException);
                        }
                        return VOID;
                    }
                }
                IO.throwArgSizeException();
            }
        }
        IO.throwArgSizeException();
        return VOID;
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Value construct(Object object, int n) {
            return new IO(n);
        }

        public Index() {
            this.define("absolute-path?", 0);
            this.define("char-ready?", 3);
            this.define("close-input-port", 4);
            this.define("close-output-port", 5);
            this.define("display", 8);
            this.define("file-exists?", 9);
            this.define("find-resource", 6);
            this.define("find-resources", 2);
            this.define("flush-output-port", 10);
            this.define("input-port?", 12);
            this.define("input-port-location", 13);
            this.define("load", 14);
            this.define("load-expanded", 24);
            this.define("normalize-url", 16);
            this.define("open-input-file", 17);
            this.define("open-output-file", 19);
            this.define("open-source-input-file", 20);
            this.define("output-port?", 22);
            this.define("peek-byte", 30);
            this.define("peek-char", 23);
            this.define("port?", 27);
            this.define("read", 21);
            this.define("read-byte", 29);
            this.define("read-char", 18);
            this.define("read-code", 11);
            this.define("read-string", 25);
            this.define("write", 1);
            this.define("write-byte", 28);
            this.define("write-char", 7);
            this.define("write-string", 26);
        }
    }
}

