/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import sisc.data.Expression;
import sisc.data.Symbol;
import sisc.interpreter.AppContext;
import sisc.interpreter.Context;
import sisc.ser.BerEncoding;
import sisc.ser.BlockDeserializer;
import sisc.ser.BufferedRandomAccessInputStream;
import sisc.ser.MemoryRandomAccessInputStream;
import sisc.ser.SeekableDataInputStream;
import sisc.util.Util;

public class Library
extends Util {
    static final String LIBRARY_VERSION = "SLL4";
    protected String name;
    protected BlockDeserializer lib;
    protected Map names;

    public static Library load(AppContext appContext, URL uRL) throws IOException, ClassNotFoundException {
        if (uRL.getProtocol().equalsIgnoreCase("file")) {
            String string = uRL.getPath();
            return Library.load(appContext, new SeekableDataInputStream(new BufferedRandomAccessInputStream(string, "r")));
        }
        return Library.load(appContext, new SeekableDataInputStream(new MemoryRandomAccessInputStream(uRL.openStream())));
    }

    public static Library load(AppContext appContext, SeekableDataInputStream seekableDataInputStream) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        String string = seekableDataInputStream.readUTF();
        if (!string.equals(LIBRARY_VERSION)) {
            throw new IOException(Library.liMessage(SISCB, "unsuplib"));
        }
        String string2 = seekableDataInputStream.readUTF();
        int n3 = BerEncoding.readBer(seekableDataInputStream);
        HashMap hashMap = new HashMap(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            hashMap.put(new Integer(n2), Class.forName(seekableDataInputStream.readUTF()));
        }
        n2 = BlockDeserializer.readBer(seekableDataInputStream);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        HashMap<Symbol, Integer> hashMap2 = new HashMap<Symbol, Integer>();
        for (n = 0; n < n2; ++n) {
            nArray[n] = BlockDeserializer.readBer(seekableDataInputStream);
            nArray2[n] = BlockDeserializer.readBer(seekableDataInputStream);
        }
        n = BlockDeserializer.readBer(seekableDataInputStream);
        for (int i = 0; i < n; ++i) {
            String string3 = seekableDataInputStream.readUTF();
            int n4 = BlockDeserializer.readBer(seekableDataInputStream);
            hashMap2.put(Symbol.intern(string3), new Integer(n4));
        }
        return new Library(string2, new BlockDeserializer(appContext, seekableDataInputStream, hashMap, nArray, nArray2), hashMap2);
    }

    public Library(String string, BlockDeserializer blockDeserializer, Map map) {
        this.name = string;
        this.lib = blockDeserializer;
        this.names = map;
        blockDeserializer.setLibrary(this);
    }

    public int getEntryPoint(Symbol symbol) {
        Integer n = (Integer)this.names.get(symbol);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public Expression getLocalExpression(Symbol symbol) throws IOException {
        Integer n = (Integer)this.names.get(symbol);
        if (n == null) {
            throw new FileNotFoundException(Library.liMessage(SISCB, "namedlibbindingnotfound", symbol.toString()));
        }
        return this.getExpression(n);
    }

    public Expression getExpression(Symbol symbol) throws IOException {
        try {
            return this.getLocalExpression(symbol);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return Context.currentAppContext().getExpression(symbol);
        }
    }

    public Expression getExpression(int n) throws IOException {
        if (n == -1) {
            return null;
        }
        Expression expression = this.lib.fetchShared(n);
        return expression;
    }

    public String getName() {
        return this.name;
    }

    public int reverseLookup(Expression expression) {
        for (int i = this.lib.alreadyReadObjects.length - 1; i >= 0; --i) {
            if (this.lib.alreadyReadObjects[i] != expression) continue;
            return i;
        }
        return -1;
    }
}

