/*
 * Decompiled with CFR 0.152.
 */
package sisc.ser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import sisc.ser.SeekableInputStream;

public class MemoryRandomAccessInputStream
extends SeekableInputStream {
    protected byte[] data;
    protected int filePointer;

    public MemoryRandomAccessInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        byte[] byArray = new byte[65536];
        while (-1 != (n = inputStream.read(byArray))) {
            if (n <= 0) continue;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        this.data = byteArrayOutputStream.toByteArray();
    }

    public void seek(long l) throws IOException {
        this.filePointer = (int)l;
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public int read() throws IOException {
        if (this.filePointer == this.data.length) {
            return -1;
        }
        return this.data[this.filePointer++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = Math.min(n2, this.data.length - this.filePointer);
        if (n3 == 0 && n2 > 0) {
            return -1;
        }
        System.arraycopy(this.data, this.filePointer, byArray, n, n3);
        this.filePointer += n3;
        return n3;
    }

    public int skipBytes(int n) throws IOException {
        int n2 = Math.min(n, this.data.length - this.filePointer);
        this.filePointer += n2;
        return n2;
    }
}

