/*
 * Decompiled with CFR 0.152.
 */
package sisc.util;

import java.io.IOException;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.env.SymbolicEnvironment;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitee;
import sisc.util.ExpressionVisitor;
import sisc.util.UndefinedVarException;
import sisc.util.Util;

public class FreeReference
implements ExpressionVisitee {
    private Symbol sym;
    private SymbolicEnvironment senv;
    private transient int envLoc = -1;

    public FreeReference(Symbol symbol, SymbolicEnvironment symbolicEnvironment) {
        this.senv = symbolicEnvironment;
        this.sym = symbol;
    }

    public Symbol getName() {
        return this.sym;
    }

    private void resolve() throws UndefinedVarException {
        this.senv = (SymbolicEnvironment)((Object)this.senv.asValue());
        this.envLoc = this.senv.getLoc(this.sym);
        if (this.envLoc < 0) {
            throw new UndefinedVarException(this.sym.toString());
        }
    }

    public Value getValue() throws UndefinedVarException {
        if (this.envLoc < 0) {
            this.resolve();
        }
        return this.senv.lookup(this.envLoc);
    }

    public void setValue(Value value) throws UndefinedVarException {
        if (this.envLoc < 0) {
            this.resolve();
        }
        this.senv.set(this.envLoc, value);
        Util.updateName(value, this.sym);
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeExpression(this.sym);
        serializer.writeSymbolicEnvironment(this.senv);
    }

    public FreeReference() {
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.sym = (Symbol)deserializer.readExpression();
        this.senv = deserializer.readSymbolicEnvironment();
        this.envLoc = -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FreeReference)) {
            return false;
        }
        FreeReference freeReference = (FreeReference)object;
        return this.sym.equals(freeReference.sym) && this.senv.equals(freeReference.senv);
    }

    public int hashCode() {
        return this.sym.hashCode() ^ this.senv.hashCode();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        return expressionVisitor.visit(this.sym) && expressionVisitor.visit(this.senv);
    }
}

