/*
 * Decompiled with CFR 0.152.
 */
package sisc.boot;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import sisc.compiler.Compiler;
import sisc.data.Procedure;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.env.MemorySymEnv;
import sisc.env.SymbolicEnvironment;
import sisc.interpreter.AppContext;
import sisc.interpreter.Context;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeException;
import sisc.modules.Annotations;
import sisc.modules.Primitives;
import sisc.modules.io.IO;
import sisc.modules.io.StringIO;
import sisc.ser.BufferedRandomAccessInputStream;
import sisc.ser.LibraryAE;
import sisc.ser.LibraryBuilder;
import sisc.ser.SeekableDataInputStream;
import sisc.ser.SeekableInputStream;
import sisc.util.Defaults;
import sisc.util.Util;

public class GenerateHeap {
    static HashSet r5rs_bindings;
    static String[] bindingNames;

    static SymbolicEnvironment[] classify(SymbolicEnvironment symbolicEnvironment, LibraryBuilder libraryBuilder) {
        Value value;
        Object object;
        SymbolicEnvironment[] symbolicEnvironmentArray = new SymbolicEnvironment[]{new LibraryAE((Symbol)null, libraryBuilder), symbolicEnvironment};
        ((MemorySymEnv)symbolicEnvironmentArray[0]).sidecars = ((MemorySymEnv)symbolicEnvironment).sidecars;
        ((MemorySymEnv)symbolicEnvironment).sidecars = new HashMap();
        symbolicEnvironmentArray[1].setParent(symbolicEnvironmentArray[0]);
        HashMap<Object, Value> hashMap = new HashMap<Object, Value>();
        Object object2 = symbolicEnvironment.keys();
        while (object2.hasNext()) {
            object = (Symbol)object2.next();
            if (!r5rs_bindings.contains(((Symbol)object).symval)) continue;
            value = symbolicEnvironment.lookup((Symbol)object);
            hashMap.put(object, value);
            symbolicEnvironmentArray[0].define((Symbol)object, value);
        }
        object2 = symbolicEnvironment.getSymbolMap();
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            value = (Symbol)object.next();
            object2.remove(value);
            if (!(symbolicEnvironment instanceof LibraryAE)) continue;
            ((LibraryAE)symbolicEnvironment).ignore((Symbol)value);
        }
        return symbolicEnvironmentArray;
    }

    private static void patchDefaults() {
        Defaults.EMIT_ANNOTATIONS = false;
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        String string = null;
        String string2 = null;
        for (n = 0; n < stringArray.length; ++n) {
            if ("-in".equalsIgnoreCase(stringArray[n])) {
                string = stringArray[++n];
                continue;
            }
            if ("-out".equalsIgnoreCase(stringArray[n])) {
                string2 = stringArray[++n];
                continue;
            }
            if (!"-files".equalsIgnoreCase(stringArray[n])) continue;
            ++n;
            break;
        }
        if (string2 == null) {
            System.out.println("Output heap file name has not been specified!");
            System.exit(1);
        }
        GenerateHeap.patchDefaults();
        LibraryBuilder libraryBuilder = new LibraryBuilder();
        LibraryAE libraryAE = new LibraryAE(Symbol.get((String)"symenv"), libraryBuilder);
        LibraryAE libraryAE2 = new LibraryAE((Symbol)null, libraryBuilder);
        libraryAE2.setName(Util.TOPLEVEL);
        Compiler.addSpecialForms((SymbolicEnvironment)libraryAE2);
        libraryAE.define(Util.TOPLEVEL, (Value)libraryAE2);
        libraryAE.define(Util.REPORT, (Value)libraryAE2);
        libraryAE.define(Util.SISC_SPECIFIC, (Value)libraryAE2);
        AppContext appContext = new AppContext((SymbolicEnvironment)libraryAE);
        Context.setDefaultAppContext((AppContext)appContext);
        libraryBuilder.setAppContext(appContext);
        Interpreter interpreter = Context.enter((AppContext)appContext);
        new Primitives.Index().bindAll(interpreter, appContext.toplevel_env);
        new Annotations.Index().bindAll(interpreter, appContext.toplevel_env);
        new IO.Index().bindAll(interpreter, appContext.toplevel_env);
        new StringIO.Index().bindAll(interpreter, appContext.toplevel_env);
        Symbol symbol = Symbol.get((String)"load-expanded");
        Symbol symbol2 = Symbol.get((String)"load");
        if (string != null) {
            System.out.println("Reading input heap: " + string);
            appContext.loadEnv(new SeekableDataInputStream((SeekableInputStream)new BufferedRandomAccessInputStream(string, "r", 1, 8192)));
        }
        interpreter.define(Symbol.get((String)"version"), (Value)new SchemeString("1.13.4"), Util.SISC);
        System.out.println("Generating heap: " + string2);
        Procedure procedure = null;
        while (n < stringArray.length) {
            System.out.println("Expanding and compiling " + stringArray[n] + "...");
            try {
                procedure = stringArray[n].endsWith("sce") ? (Procedure)interpreter.getCtx().toplevel_env.lookup(symbol) : (Procedure)interpreter.getCtx().toplevel_env.lookup(symbol2);
                interpreter.eval(procedure, new Value[]{new SchemeString(stringArray[n])});
            }
            catch (SchemeException schemeException) {
                System.err.println("Error during expand: " + schemeException.getMessage());
                try {
                    interpreter.eval((Procedure)interpreter.eval((Value)Symbol.get((String)"print-exception")), new Value[]{schemeException.m});
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        System.err.println("Partitioning bindings...");
        SymbolicEnvironment[] symbolicEnvironmentArray = GenerateHeap.classify(interpreter.lookupContextEnv(Util.TOPLEVEL), libraryBuilder);
        SymbolicEnvironment symbolicEnvironment = symbolicEnvironmentArray[0];
        SymbolicEnvironment symbolicEnvironment2 = symbolicEnvironmentArray[1];
        symbolicEnvironment2 = new LibraryAE(symbolicEnvironment2, libraryBuilder);
        symbolicEnvironment2.setName(Util.SISC_SPECIFIC);
        MemorySymEnv memorySymEnv = new MemorySymEnv(symbolicEnvironment2, Util.TOPLEVEL);
        interpreter.getCtx().toplevel_env = memorySymEnv;
        symbolicEnvironment.setName(Util.REPORT);
        symbolicEnvironment2.setName(Util.SISC_SPECIFIC);
        libraryAE2.setName(Symbol.get((String)"*toplevel-lib*"));
        interpreter.defineContextEnv(Util.TOPLEVEL, (SymbolicEnvironment)memorySymEnv);
        interpreter.defineContextEnv(Util.REPORT, symbolicEnvironment);
        interpreter.defineContextEnv(Util.SISC_SPECIFIC, symbolicEnvironment2);
        System.out.println("Saving heap...");
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            appContext.saveEnv((OutputStream)bufferedOutputStream, libraryBuilder);
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            System.err.println("Error generating heap:");
            exception.printStackTrace();
            System.exit(1);
        }
        System.out.println("Heap saved.");
        Context.exit();
    }

    static {
        bindingNames = new String[]{"lambda", "quote", "letrec", "if", "begin", "set!", "define", "*", "+", "-", "/", "<", "<=", "=", ">", ">=", "abs", "acos", "angle", "append", "apply", "asin", "assoc", "assq", "assv", "atan", "boolean?", "call-with-current-continuation", "call-with-input-file", "call-with-output-file", "call-with-values", "car", "cdr", "caar", "cadr", "cdar", "cddr", "caaar", "caadr", "cadar", "caddr", "cdaar", "cdadr", "cddar", "cdddr", "caaaar", "caaadr", "caadar", "caaddr", "cadaar", "cadadr", "caddar", "cadddr", "cdaaar", "cdaadr", "cdadar", "cdaddr", "cddaar", "cddadr", "cdddar", "cddddr", "ceiling", "char->integer", "char-alphabetic?", "char-ci<=?", "char-ci<?", "char-ci=?", "char-ci>=?", "char-ci>?", "char-downcase", "char-lower-case?", "char-numeric?", "char-ready?", "char-upcase", "char-upper-case?", "char-whitespace?", "char<=?", "char<?", "char=?", "char>=?", "char>?", "char?", "close-input-port", "close-output-port", "complex?", "cons", "cos", "current-input-port", "current-output-port", "denominator", "display", "dynamic-wind", "eof-object?", "eq?", "equal?", "eqv?", "eval", "even?", "exact->inexact", "exact?", "exp", "expt", "floor", "for-each", "force", "gcd", "imag-part", "inexact->exact", "inexact?", "input-port?", "integer->char", "integer?", "interaction-environment", "lcm", "length", "list", "list->string", "list->vector", "list-ref", "list-tail", "list?", "load", "log", "magnitude", "make-polar", "make-rectangular", "make-string", "make-vector", "map", "max", "member", "memq", "memv", "min", "modulo", "negative?", "newline", "not", "null-environment", "null?", "number->string", "number?", "numerator", "odd?", "open-input-file", "open-output-file", "output-port?", "pair?", "peek-char", "positive?", "procedure?", "quotient", "rational?", "rationalize", "read", "read-char", "real-part", "real?", "remainder", "reverse", "round", "scheme-report-environment", "set-car!", "set-cdr!", "sin", "sqrt", "string", "string->list", "string->number", "string->symbol", "string-append", "string-ci<=?", "string-ci<?", "string-ci=?", "string-ci>=?", "string-ci>?", "string-copy", "string-fill!", "string-length", "string-ref", "string-set!", "string<=?", "string<?", "string=?", "string>=?", "string>?", "string?", "substring", "symbol->string", "symbol?", "tan", "truncate", "values", "vector", "vector->list", "vector-fill!", "vector-length", "vector-ref", "vector-set!", "vector?", "with-input-from-file", "with-output-to-file", "write", "write-char", "zero?", "make-promise", "$syntax-dispatch", "$sc-put-cte", "syntax-error"};
        r5rs_bindings = new HashSet(bindingNames.length);
        for (int i = 0; i < bindingNames.length; ++i) {
            r5rs_bindings.add(bindingNames[i]);
        }
    }
}

