/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.hashtable;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sisc.data.EmptyList;
import sisc.data.Expression;
import sisc.data.Pair;
import sisc.data.Procedure;
import sisc.data.Quantity;
import sisc.data.SchemeBoolean;
import sisc.data.SchemeVoid;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.Context;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.interpreter.SchemeException;
import sisc.io.ValueWriter;
import sisc.modules.hashtable.HashtableBase;
import sisc.modules.hashtable.HashtableKey;
import sisc.modules.hashtable.Primitives;
import sisc.nativefun.FixableProcedure;
import sisc.ser.Deserializer;
import sisc.ser.Serializer;
import sisc.util.ExpressionVisitee;
import sisc.util.ExpressionVisitor;
import sisc.util.Util;

public class Hashtable
extends HashtableBase {
    private HashMap ht = new HashMap(0);
    private Pair alist;
    private Procedure equalsProc;
    private Procedure hashProc;

    public Hashtable() {
    }

    public Hashtable(Procedure procedure, Procedure procedure2) {
        this();
        this.equalsProc = procedure;
        this.hashProc = procedure2;
    }

    public Procedure getEqualsProc() {
        return this.equalsProc;
    }

    public Procedure getHashProc() {
        return this.hashProc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean callEquals(Value value, Value value2) {
        SchemeVoid schemeVoid = Util.VOID;
        if (this.equalsProc instanceof FixableProcedure) {
            try {
                schemeVoid = ((FixableProcedure)this.equalsProc).apply(value, value2);
            }
            catch (ContinuationException continuationException) {
                Procedure.throwPrimException((String)continuationException.getMessage());
            }
        } else {
            Interpreter interpreter = Context.enter();
            try {
                schemeVoid = interpreter.eval(this.equalsProc, new Value[]{value, value2});
            }
            catch (SchemeException schemeException) {
                Procedure.throwNestedPrimException((String)Util.liMessage((Symbol)Primitives.SHASHB, (String)"equalsexception", (String)this.equalsProc.toString()), (SchemeException)schemeException);
            }
            finally {
                Context.exit();
            }
        }
        if (schemeVoid instanceof SchemeBoolean) {
            return Util.truth((Value)((SchemeBoolean)schemeVoid));
        }
        Procedure.throwPrimException((String)Util.liMessage((Symbol)Primitives.SHASHB, (String)"equalsreturn", (String)this.equalsProc.toString(), (String)schemeVoid.synopsis()));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int callHashCode(Value value) {
        SchemeVoid schemeVoid = Util.VOID;
        if (this.hashProc instanceof FixableProcedure) {
            try {
                schemeVoid = ((FixableProcedure)this.hashProc).apply(value);
            }
            catch (ContinuationException continuationException) {
                Procedure.throwPrimException((String)continuationException.getMessage());
            }
        } else {
            Interpreter interpreter = Context.enter();
            try {
                schemeVoid = interpreter.eval(this.hashProc, new Value[]{value});
            }
            catch (SchemeException schemeException) {
                Procedure.throwNestedPrimException((String)Util.liMessage((Symbol)Primitives.SHASHB, (String)"hashexception", (String)this.hashProc.toString()), (SchemeException)schemeException);
            }
            finally {
                Context.exit();
            }
        }
        if (schemeVoid instanceof Quantity) {
            return ((Quantity)schemeVoid).intValue();
        }
        Procedure.throwPrimException((String)Util.liMessage((Symbol)Primitives.SHASHB, (String)"hashreturn", (String)this.hashProc.toString(), (String)schemeVoid.synopsis()));
        return 0;
    }

    protected HashtableKey makeKey(Value value) {
        return new Key(value);
    }

    protected Map getMap() {
        if (this.alist != null) {
            this.addAList(this.ht, this.alist);
            this.alist = null;
        }
        return this.ht;
    }

    private void addAList(Map map, Pair pair) {
        while (pair != EMPTYLIST) {
            Pair pair2 = Hashtable.pair((Value)pair.car());
            map.put(this.makeKey(pair2.car()), pair2.cdr());
            pair = Hashtable.pair((Value)pair.cdr());
        }
    }

    private Value getKey(Object object) {
        return ((HashtableKey)object).getValue();
    }

    private Value getMapKey(Map.Entry entry) {
        return this.getKey(entry.getKey());
    }

    private Value getMapValue(Map.Entry entry) {
        return (Value)entry.getValue();
    }

    public Value get(Value value) {
        return (Value)this.getMap().get(this.makeKey(value));
    }

    public Value put(Value value, Value value2) {
        return this.getMap().put(this.makeKey(value), value2);
    }

    public Value remove(Value value) {
        return (Value)this.getMap().remove(this.makeKey(value));
    }

    public int size() {
        return this.getMap().size();
    }

    public void clear() {
        this.getMap().clear();
    }

    public void addAList(Pair pair) {
        Map map = this.getMap();
        this.addAList(map, pair);
    }

    public Pair toAList() {
        Iterator iterator = this.getMap().entrySet().iterator();
        EmptyList emptyList = EMPTYLIST;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Value value = this.getMapKey(entry);
            Value value2 = this.getMapValue(entry);
            if (value == null) continue;
            emptyList = new Pair((Value)new Pair(value, value2), (Value)emptyList);
        }
        return emptyList;
    }

    public Pair keys() {
        Iterator iterator = this.getMap().keySet().iterator();
        EmptyList emptyList = EMPTYLIST;
        while (iterator.hasNext()) {
            Value value = this.getKey(iterator.next());
            if (value == null) continue;
            emptyList = new Pair(value, (Value)emptyList);
        }
        return emptyList;
    }

    public boolean valueEqual(Value value) {
        if (value == this) {
            return true;
        }
        if (!(value instanceof Hashtable)) {
            return false;
        }
        Hashtable hashtable = (Hashtable)value;
        if (this.size() != hashtable.size()) {
            return false;
        }
        if (!this.equalsProc.valueEqual((Value)hashtable.equalsProc) || !this.hashProc.valueEqual((Value)hashtable.hashProc)) {
            return false;
        }
        Iterator iterator = this.getMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Value value2 = this.getMapKey(entry);
            Value value3 = this.getMapValue(entry);
            if (value2 != null && value3.valueEqual(hashtable.get(value2))) continue;
            return false;
        }
        return true;
    }

    public int valueHashCode() {
        int n = this.equalsProc.valueHashCode() ^ this.hashProc.valueHashCode();
        Iterator iterator = this.getMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Value value = this.getMapKey(entry);
            Value value2 = this.getMapValue(entry);
            if (value == null) continue;
            n += value.valueHashCode() ^ value2.valueHashCode();
        }
        return n;
    }

    public void serialize(Serializer serializer) throws IOException {
        serializer.writeExpression((Expression)this.equalsProc);
        serializer.writeExpression((Expression)this.hashProc);
        serializer.writeExpression((Expression)this.toAList());
    }

    public void deserialize(Deserializer deserializer) throws IOException {
        this.equalsProc = (Procedure)deserializer.readExpression();
        this.hashProc = (Procedure)deserializer.readExpression();
        this.alist = (Pair)deserializer.readExpression();
    }

    public boolean visit(ExpressionVisitor expressionVisitor) {
        if (!expressionVisitor.visit((ExpressionVisitee)this.equalsProc) || !expressionVisitor.visit((ExpressionVisitee)this.hashProc)) {
            return false;
        }
        Iterator iterator = this.getMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Value value = this.getMapKey(entry);
            Value value2 = this.getMapValue(entry);
            if (value == null) continue;
            if (!expressionVisitor.visit((ExpressionVisitee)value)) {
                return false;
            }
            if (expressionVisitor.visit((ExpressionVisitee)value2)) continue;
            return false;
        }
        return true;
    }

    public void display(ValueWriter valueWriter) throws IOException {
        valueWriter.append("#<").append(Util.liMessage((Symbol)Primitives.SHASHB, (String)"hashtable")).append(' ').append((Value)this.equalsProc).append(' ').append((Value)this.hashProc).append(" (");
        Iterator iterator = this.getMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Value value = this.getMapKey(entry);
            Value value2 = this.getMapValue(entry);
            if (value == null) continue;
            valueWriter.append('(').append(value).append(" . ").append(value2).append(')');
        }
        valueWriter.append(")>");
    }

    private class Key
    implements HashtableKey {
        private Value key;

        public Key(Value value) {
            this.key = value;
        }

        public Value getValue() {
            return this.key;
        }

        public boolean equals(Object object) {
            return object instanceof Key && Hashtable.this.callEquals(this.key, ((Key)object).key);
        }

        public int hashCode() {
            return Hashtable.this.callHashCode(this.key);
        }
    }
}

