/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.hashtable;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import sisc.data.Procedure;
import sisc.data.Value;
import sisc.modules.hashtable.Hashtable;
import sisc.modules.hashtable.HashtableKey;

public class WeakHashtable
extends Hashtable {
    private ReferenceQueue garbage = new ReferenceQueue();

    public WeakHashtable() {
    }

    public WeakHashtable(Procedure procedure, Procedure procedure2) {
        super(procedure, procedure2);
    }

    protected HashtableKey makeKey(Value value) {
        return new Key(value);
    }

    protected Map getMap() {
        Reference reference;
        Map map = super.getMap();
        while ((reference = this.garbage.poll()) != null) {
            map.remove(reference);
        }
        return map;
    }

    public boolean valueEqual(Value value) {
        if (!(value instanceof WeakHashtable)) {
            return false;
        }
        return super.valueEqual(value);
    }

    private class Key
    extends WeakReference
    implements HashtableKey {
        private int hash;

        public Key(Value value) {
            super(value, WeakHashtable.this.garbage);
            this.hash = WeakHashtable.this.callHashCode(value);
        }

        public Value getValue() {
            return (Value)this.get();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            Value value = this.getValue();
            Value value2 = ((Key)object).getValue();
            return value != null && value2 != null && WeakHashtable.this.callEquals(value, value2);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

