/*
 * Decompiled with CFR 0.152.
 */
package sisc.modules.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import sisc.data.SchemeInputPort;
import sisc.data.SchemeOutputPort;
import sisc.data.SchemeString;
import sisc.data.Symbol;
import sisc.data.Value;
import sisc.interpreter.ContinuationException;
import sisc.interpreter.Interpreter;
import sisc.io.Charset;
import sisc.io.ReaderInputPort;
import sisc.io.StreamInputPort;
import sisc.io.StreamOutputPort;
import sisc.io.ValueWriter;
import sisc.io.WriterOutputPort;
import sisc.modules.io.IO;
import sisc.nativefun.IndexedLibraryAdapter;
import sisc.nativefun.IndexedProcedure;
import sisc.util.Util;

public class Networking
extends IndexedProcedure {
    static final Symbol SNETB = Symbol.intern((String)"sisc.modules.io.Messages");
    protected static final int GET_LOCAL_HOST = 0;
    protected static final int GET_HOST_NAME_BY_IP = 1;
    protected static final int GET_HOST_IP_BY_NAME = 2;
    protected static final int SET_MULTICAST_TTL = 3;
    protected static final int LEAVE_MULTICAST_GROUP = 4;
    protected static final int JOIN_MULTICAST_GROUP = 5;
    protected static final int OPEN_MULTICAST_SOCKET = 6;
    protected static final int OPEN_UDP_SOCKET = 9;
    protected static final int ACCEPT_TCP_SOCKET = 7;
    protected static final int OPEN_SOCKET_OUTPUT_PORT = 10;
    protected static final int OPEN_SOCKET_INPUT_PORT = 11;
    protected static final int OPEN_BINARY_SOCKET_OUTPUT_PORT = 12;
    protected static final int OPEN_BINARY_SOCKET_INPUT_PORT = 13;
    protected static final int OPEN_TCP_SOCKET = 14;
    protected static final int OPEN_TCP_LISTENER = 15;
    protected static final int CLOSE_SOCKET = 16;
    protected static final int SET_SO_TIMEOUT = 17;
    protected static final int OPEN_UDP_LISTEN_SOCKET = 18;
    protected static final int SOCKETQ = 19;
    protected static final int SERVERSOCKETQ = 20;
    static final int LISTEN = 1;
    static final int SEND = 2;

    public Networking(int n) {
        super(n);
    }

    public Networking() {
    }

    public static SchemeSocket sock(Value value) {
        try {
            return (SchemeSocket)value;
        }
        catch (ClassCastException classCastException) {
            Networking.typeError((Symbol)SNETB, (String)"socket", (Value)value);
            return null;
        }
    }

    public static SchemeMulticastUDPSocket mcastsock(Value value) {
        try {
            return (SchemeMulticastUDPSocket)value;
        }
        catch (ClassCastException classCastException) {
            Networking.typeError((Symbol)SNETB, (String)"multicastudpsocket", (Value)value);
            return null;
        }
    }

    public static SchemeServerSocket serversock(Value value) {
        try {
            return (SchemeServerSocket)value;
        }
        catch (ClassCastException classCastException) {
            Networking.typeError((Symbol)SNETB, (String)"tcplistensocket", (Value)value);
            return null;
        }
    }

    public Value doApply(Interpreter interpreter) throws ContinuationException {
        try {
            switch (interpreter.vlr.length) {
                case 0: {
                    switch (this.id) {
                        case 0: {
                            return new SchemeString(InetAddress.getLocalHost().getHostAddress());
                        }
                    }
                    Networking.throwArgSizeException();
                }
                case 1: {
                    switch (this.id) {
                        case 19: {
                            return Networking.truth((boolean)(interpreter.vlr[0] instanceof SchemeSocket));
                        }
                        case 20: {
                            return Networking.truth((boolean)(interpreter.vlr[0] instanceof SchemeServerSocket));
                        }
                        case 11: {
                            SchemeSocket schemeSocket = Networking.sock(interpreter.vlr[0]);
                            return schemeSocket.getInputPort(interpreter);
                        }
                        case 10: {
                            SchemeSocket schemeSocket = Networking.sock(interpreter.vlr[0]);
                            return schemeSocket.getOutputPort(interpreter, false);
                        }
                        case 13: {
                            SchemeSocket schemeSocket = Networking.sock(interpreter.vlr[0]);
                            return schemeSocket.getBinaryInputPort(interpreter);
                        }
                        case 12: {
                            SchemeSocket schemeSocket = Networking.sock(interpreter.vlr[0]);
                            return schemeSocket.getBinaryOutputPort(interpreter, false);
                        }
                        case 16: {
                            Closable closable = (Closable)interpreter.vlr[0];
                            closable.close();
                            return VOID;
                        }
                        case 1: {
                            String string = Networking.string((Value)interpreter.vlr[0]);
                            InetAddress inetAddress = InetAddress.getByName(string);
                            return new SchemeString(inetAddress.getHostName());
                        }
                        case 2: {
                            String string = Networking.string((Value)interpreter.vlr[0]);
                            InetAddress inetAddress = InetAddress.getByName(string);
                            return new SchemeString(inetAddress.getHostAddress());
                        }
                        case 15: {
                            int n = Networking.num((Value)interpreter.vlr[0]).indexValue();
                            return new SchemeServerSocket(new ServerSocket(n));
                        }
                        case 7: {
                            Socket socket = Networking.serversock((Value)interpreter.vlr[0]).s.accept();
                            return new SchemeTCPSocket(socket);
                        }
                        case 18: {
                            int n = Networking.num((Value)interpreter.vlr[0]).indexValue();
                            SchemeUDPSocket schemeUDPSocket = new SchemeUDPSocket(new DatagramSocket(n));
                            schemeUDPSocket.setMode(1);
                            return schemeUDPSocket;
                        }
                        case 6: {
                            int n = Networking.num((Value)interpreter.vlr[0]).indexValue();
                            SchemeMulticastUDPSocket schemeMulticastUDPSocket = new SchemeMulticastUDPSocket(new MulticastSocket(n));
                            schemeMulticastUDPSocket.setMode(1);
                            return schemeMulticastUDPSocket;
                        }
                    }
                    Networking.throwArgSizeException();
                }
                case 2: {
                    switch (this.id) {
                        case 14: {
                            String string = Networking.string((Value)interpreter.vlr[0]);
                            int n = Networking.num((Value)interpreter.vlr[1]).indexValue();
                            return new SchemeTCPSocket(new Socket(string, n));
                        }
                        case 9: {
                            String string = Networking.string((Value)interpreter.vlr[0]);
                            int n = Networking.num((Value)interpreter.vlr[1]).indexValue();
                            SchemeUDPSocket schemeUDPSocket = new SchemeUDPSocket(new DatagramSocket(), n, string);
                            schemeUDPSocket.setMode(2);
                            return schemeUDPSocket;
                        }
                        case 18: {
                            int n = Networking.num((Value)interpreter.vlr[0]).indexValue();
                            int n2 = Networking.num((Value)interpreter.vlr[1]).indexValue();
                            SchemeUDPSocket schemeUDPSocket = new SchemeUDPSocket(new DatagramSocket(n), n2);
                            schemeUDPSocket.setMode(1);
                            return schemeUDPSocket;
                        }
                        case 6: {
                            if (interpreter.vlr[0] instanceof SchemeString) {
                                String string = Networking.string((Value)interpreter.vlr[0]);
                                int n = Networking.num((Value)interpreter.vlr[1]).indexValue();
                                SchemeMulticastUDPSocket schemeMulticastUDPSocket = new SchemeMulticastUDPSocket(new MulticastSocket(n), n, string);
                                schemeMulticastUDPSocket.setMode(3);
                                return schemeMulticastUDPSocket;
                            }
                            if (interpreter.vlr[1] instanceof SchemeString) {
                                String string = Networking.string((Value)interpreter.vlr[1]);
                                int n = Networking.num((Value)interpreter.vlr[0]).indexValue();
                                MulticastSocket multicastSocket = new MulticastSocket(n);
                                multicastSocket.setInterface(InetAddress.getByName(string));
                                SchemeMulticastUDPSocket schemeMulticastUDPSocket = new SchemeMulticastUDPSocket(multicastSocket);
                                schemeMulticastUDPSocket.setMode(1);
                                return schemeMulticastUDPSocket;
                            }
                            int n = Networking.num((Value)interpreter.vlr[0]).indexValue();
                            int n3 = Networking.num((Value)interpreter.vlr[1]).indexValue();
                            SchemeMulticastUDPSocket schemeMulticastUDPSocket = new SchemeMulticastUDPSocket(new MulticastSocket(n), n3);
                            schemeMulticastUDPSocket.setMode(1);
                            return schemeMulticastUDPSocket;
                        }
                        case 12: {
                            SchemeSocket schemeSocket = Networking.sock(interpreter.vlr[0]);
                            return schemeSocket.getBinaryOutputPort(interpreter, Networking.truth((Value)interpreter.vlr[1]));
                        }
                        case 11: {
                            SchemeSocket schemeSocket = Networking.sock(interpreter.vlr[0]);
                            return schemeSocket.getInputPort(interpreter, Util.charsetFromString((String)Networking.string((Value)interpreter.vlr[1])));
                        }
                        case 10: {
                            SchemeSocket schemeSocket = Networking.sock(interpreter.vlr[0]);
                            if (interpreter.vlr[1] instanceof SchemeString) {
                                return schemeSocket.getOutputPort(interpreter, Util.charsetFromString((String)Networking.string((Value)interpreter.vlr[1])));
                            }
                            return schemeSocket.getBinaryOutputPort(interpreter, Networking.truth((Value)interpreter.vlr[1]));
                        }
                        case 3: {
                            SchemeMulticastUDPSocket schemeMulticastUDPSocket = Networking.mcastsock(interpreter.vlr[0]);
                            int n = Networking.num((Value)interpreter.vlr[1]).indexValue();
                            schemeMulticastUDPSocket.setTTL(n);
                            return VOID;
                        }
                        case 5: {
                            SchemeMulticastUDPSocket schemeMulticastUDPSocket = Networking.mcastsock(interpreter.vlr[0]);
                            String string = Networking.string((Value)interpreter.vlr[1]);
                            schemeMulticastUDPSocket.joinGroup(InetAddress.getByName(string));
                            return VOID;
                        }
                        case 4: {
                            SchemeMulticastUDPSocket schemeMulticastUDPSocket = Networking.mcastsock(interpreter.vlr[0]);
                            String string = Networking.string((Value)interpreter.vlr[1]);
                            schemeMulticastUDPSocket.leaveGroup(InetAddress.getByName(string));
                            return VOID;
                        }
                        case 17: {
                            if (interpreter.vlr[0] instanceof SchemeSocket) {
                                SchemeTCPSocket schemeTCPSocket = (SchemeTCPSocket)Networking.sock(interpreter.vlr[0]);
                                schemeTCPSocket.setSoTimeout(Networking.num((Value)interpreter.vlr[1]).intValue());
                            } else {
                                SchemeServerSocket schemeServerSocket = Networking.serversock(interpreter.vlr[0]);
                                schemeServerSocket.setSoTimeout(Networking.num((Value)interpreter.vlr[1]).intValue());
                            }
                            return VOID;
                        }
                    }
                    Networking.throwArgSizeException();
                }
                case 3: {
                    switch (this.id) {
                        case 18: {
                            int n = Networking.num((Value)interpreter.vlr[0]).indexValue();
                            String string = Networking.string((Value)interpreter.vlr[0]);
                            int n4 = Networking.num((Value)interpreter.vlr[2]).indexValue();
                            DatagramSocket datagramSocket = new DatagramSocket(n, InetAddress.getByName(string));
                            SchemeUDPSocket schemeUDPSocket = new SchemeUDPSocket(datagramSocket, n4);
                            schemeUDPSocket.setMode(3);
                            return schemeUDPSocket;
                        }
                        case 6: {
                            String string = Networking.string((Value)interpreter.vlr[0]);
                            int n = Networking.num((Value)interpreter.vlr[1]).indexValue();
                            int n5 = Networking.num((Value)interpreter.vlr[2]).indexValue();
                            SchemeMulticastUDPSocket schemeMulticastUDPSocket = new SchemeMulticastUDPSocket(new MulticastSocket(n), string, n5);
                            schemeMulticastUDPSocket.setMode(3);
                            return schemeMulticastUDPSocket;
                        }
                        case 10: {
                            SchemeSocket schemeSocket = Networking.sock(interpreter.vlr[0]);
                            return schemeSocket.getOutputPort(interpreter, Util.charsetFromString((String)Networking.string((Value)interpreter.vlr[1])), Networking.truth((Value)interpreter.vlr[2]));
                        }
                    }
                    Networking.throwArgSizeException();
                }
                case 4: {
                    switch (this.id) {
                        case 6: {
                            String string = Networking.string((Value)interpreter.vlr[0]);
                            String string2 = Networking.string((Value)interpreter.vlr[2]);
                            int n = Networking.num((Value)interpreter.vlr[1]).indexValue();
                            int n6 = Networking.num((Value)interpreter.vlr[3]).indexValue();
                            MulticastSocket multicastSocket = new MulticastSocket(n);
                            multicastSocket.setInterface(InetAddress.getByName(string2));
                            SchemeMulticastUDPSocket schemeMulticastUDPSocket = new SchemeMulticastUDPSocket(multicastSocket, string, n6);
                            schemeMulticastUDPSocket.setMode(3);
                        }
                    }
                    Networking.throwArgSizeException();
                }
            }
            Networking.throwArgSizeException();
        }
        catch (IOException iOException) {
            IO.throwIOException((Interpreter)interpreter, (String)iOException.getMessage(), (IOException)iOException);
        }
        return VOID;
    }

    public static class Index
    extends IndexedLibraryAdapter {
        public Value construct(Object object, int n) {
            return new Networking(n);
        }

        public Index() {
            this.define("open-tcp-listener", 15);
            this.define("accept-tcp-socket", 7);
            this.define("open-tcp-socket", 14);
            this.define("open-binary-socket-input-port", 13);
            this.define("open-binary-socket-output-port", 12);
            this.define("open-socket-input-port", 11);
            this.define("open-socket-output-port", 10);
            this.define("close-socket", 16);
            this.define("get-host-ip-by-name", 2);
            this.define("get-host-name-by-ip", 1);
            this.define("get-local-host", 0);
            this.define("open-udp-listen-socket", 18);
            this.define("open-udp-socket", 9);
            this.define("open-multicast-socket", 6);
            this.define("join-multicast-group", 5);
            this.define("leave-multicast-group", 4);
            this.define("set-multicast-ttl!", 3);
            this.define("set-so-timeout!", 17);
            this.define("socket?", 19);
            this.define("server-socket?", 20);
        }
    }

    public static class SchemeMulticastUDPSocket
    extends SchemeUDPSocket {
        public SchemeMulticastUDPSocket(MulticastSocket multicastSocket) {
            super(multicastSocket);
        }

        public SchemeMulticastUDPSocket(MulticastSocket multicastSocket, int n) {
            super((DatagramSocket)multicastSocket, n);
        }

        public SchemeMulticastUDPSocket(MulticastSocket multicastSocket, String string, int n) throws IOException {
            super((DatagramSocket)multicastSocket, string, n);
        }

        public SchemeMulticastUDPSocket(MulticastSocket multicastSocket, int n, String string) throws IOException {
            super((DatagramSocket)multicastSocket, n, string);
        }

        public SchemeMulticastUDPSocket(MulticastSocket multicastSocket, String string) throws IOException {
            super((DatagramSocket)multicastSocket, string);
        }

        public void display(ValueWriter valueWriter) throws IOException {
            valueWriter.append("#<").append(SchemeMulticastUDPSocket.liMessage((Symbol)SNETB, (String)"multicastudpsocket")).append('>');
        }

        public void joinGroup(InetAddress inetAddress) throws IOException {
            ((MulticastSocket)this.s).joinGroup(inetAddress);
        }

        public void leaveGroup(InetAddress inetAddress) throws IOException {
            ((MulticastSocket)this.s).leaveGroup(inetAddress);
        }

        public void setTTL(int n) throws IOException {
            ((MulticastSocket)this.s).setTimeToLive(n);
        }
    }

    public static class SchemeUDPSocket
    extends SchemeSocket {
        protected int mode;
        protected DatagramSocket s;
        protected int packet_size;
        protected InetAddress remoteHost;
        protected int dport;

        protected void setMode(int n) {
            this.mode = n;
        }

        public SchemeUDPSocket(DatagramSocket datagramSocket) {
            this(datagramSocket, 1500);
        }

        public SchemeUDPSocket(DatagramSocket datagramSocket, String string) throws IOException {
            this(datagramSocket, 1500);
            this.remoteHost = InetAddress.getByName(string);
        }

        public SchemeUDPSocket(DatagramSocket datagramSocket, int n) {
            this.s = datagramSocket;
            this.packet_size = n;
        }

        public SchemeUDPSocket(DatagramSocket datagramSocket, int n, int n2) {
            this.packet_size = n2;
            this.dport = n;
            this.s = datagramSocket;
        }

        public SchemeUDPSocket(DatagramSocket datagramSocket, String string, int n) throws IOException {
            this(datagramSocket, 1500);
            this.packet_size = n;
            this.remoteHost = InetAddress.getByName(string);
        }

        public SchemeUDPSocket(DatagramSocket datagramSocket, int n, String string) throws IOException {
            this(datagramSocket, 1500);
            this.dport = n;
            this.remoteHost = InetAddress.getByName(string);
        }

        public void display(ValueWriter valueWriter) throws IOException {
            valueWriter.append("#<").append(SchemeUDPSocket.liMessage((Symbol)SNETB, (String)"udpsocket")).append('>');
        }

        public void close() throws IOException {
            this.s.close();
        }

        public SchemeInputPort getBinaryInputPort(Interpreter interpreter) throws IOException, ContinuationException {
            if ((this.mode & 1) == 0) {
                SchemeUDPSocket.error((Interpreter)interpreter, (String)SchemeUDPSocket.liMessage((Symbol)SNETB, (String)"inputonoutputudp"));
            }
            return new StreamInputPort((InputStream)new BufferedInputStream(new UDPInputStream(this.s, this.packet_size)));
        }

        public SchemeOutputPort getBinaryOutputPort(Interpreter interpreter, boolean bl) throws IOException, ContinuationException {
            if ((this.mode & 2) == 0) {
                SchemeUDPSocket.error((Interpreter)interpreter, (String)SchemeUDPSocket.liMessage((Symbol)SNETB, (String)"outputoninputudp"));
            }
            return new StreamOutputPort((OutputStream)new UDPOutputStream(this.s, this.remoteHost, this.dport), bl);
        }

        public SchemeInputPort getInputPort(Interpreter interpreter, Charset charset) throws IOException, ContinuationException {
            if ((this.mode & 1) == 0) {
                SchemeUDPSocket.error((Interpreter)interpreter, (String)SchemeUDPSocket.liMessage((Symbol)SNETB, (String)"inputonoutputudp"));
            }
            return new ReaderInputPort((InputStream)new UDPInputStream(this.s, this.packet_size), charset);
        }

        public SchemeOutputPort getOutputPort(Interpreter interpreter, Charset charset, boolean bl) throws IOException, ContinuationException {
            if ((this.mode & 2) == 0) {
                SchemeUDPSocket.error((Interpreter)interpreter, (String)SchemeUDPSocket.liMessage((Symbol)SNETB, (String)"outputoninputudp"));
            }
            return new WriterOutputPort((OutputStream)new UDPOutputStream(this.s, this.remoteHost, this.dport), charset, bl);
        }
    }

    public static class UDPOutputStream
    extends OutputStream {
        protected DatagramPacket p;
        protected DatagramSocket ds;
        protected InetAddress host;
        protected int port;
        byte[] buffer = new byte[4096];

        public UDPOutputStream(DatagramSocket datagramSocket, InetAddress inetAddress, int n) {
            this.ds = datagramSocket;
            this.host = inetAddress;
            this.port = n;
            this.p = new DatagramPacket(this.buffer, this.buffer.length, inetAddress, n);
        }

        public void write(int n) throws IOException {
            this.buffer[0] = (byte)n;
            this.p.setData(this.buffer, 0, 1);
            this.ds.send(this.p);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.p.setData(byArray, n, n2);
            this.ds.send(this.p);
        }
    }

    public static class UDPInputStream
    extends InputStream {
        protected DatagramSocket ds;
        protected DatagramPacket p;
        byte[] buffer;
        protected int bp;
        protected int blen;

        public UDPInputStream(DatagramSocket datagramSocket, int n) {
            this.ds = datagramSocket;
            this.buffer = new byte[n];
            this.p = new DatagramPacket(this.buffer, n);
        }

        protected void receive() throws IOException {
            this.ds.receive(this.p);
            this.blen = this.p.getLength();
            byte[] byArray = this.p.getData();
            System.arraycopy(byArray, 0, this.buffer, 0, this.blen);
            this.bp = 0;
            this.p = new DatagramPacket(this.buffer, this.buffer.length);
        }

        public int available() {
            return this.blen - this.bp;
        }

        public int read() throws IOException {
            if (this.bp < this.blen) {
                return this.buffer[this.bp++];
            }
            this.receive();
            return this.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.bp < this.blen) {
                int n3 = Math.min(n2, this.blen - this.bp);
                System.arraycopy(this.buffer, this.bp, byArray, n, n3);
                this.bp += n3;
                return n3;
            }
            this.receive();
            return this.read(byArray, n, n2);
        }
    }

    public static class SchemeTCPSocket
    extends SchemeSocket {
        protected Socket s;

        public SchemeTCPSocket(Socket socket) {
            this.s = socket;
        }

        public void display(ValueWriter valueWriter) throws IOException {
            valueWriter.append("#<").append(SchemeTCPSocket.liMessage((Symbol)SNETB, (String)"tcpsocket")).append('>');
        }

        public void close() throws IOException {
            this.s.close();
        }

        public void setSoTimeout(int n) throws SocketException {
            this.s.setSoTimeout(n);
        }

        public SchemeInputPort getBinaryInputPort(Interpreter interpreter) throws IOException, ContinuationException {
            return new StreamInputPort((InputStream)new BufferedInputStream(this.s.getInputStream()));
        }

        public SchemeInputPort getInputPort(Interpreter interpreter, Charset charset) throws IOException, ContinuationException {
            return new ReaderInputPort(this.s.getInputStream(), charset);
        }

        public SchemeOutputPort getOutputPort(Interpreter interpreter, Charset charset, boolean bl) throws IOException, ContinuationException {
            return new WriterOutputPort(this.s.getOutputStream(), charset, bl);
        }

        public SchemeOutputPort getBinaryOutputPort(Interpreter interpreter, boolean bl) throws IOException, ContinuationException {
            return new StreamOutputPort((OutputStream)new BufferedOutputStream(this.s.getOutputStream()), bl);
        }
    }

    public static class SchemeServerSocket
    extends Value
    implements Closable {
        protected ServerSocket s;

        public SchemeServerSocket(ServerSocket serverSocket) {
            this.s = serverSocket;
        }

        public void display(ValueWriter valueWriter) throws IOException {
            valueWriter.append("#<").append(SchemeServerSocket.liMessage((Symbol)SNETB, (String)"tcplistensocket")).append('>');
        }

        public void close() throws IOException {
            this.s.close();
        }

        public void setSoTimeout(int n) throws SocketException {
            this.s.setSoTimeout(n);
        }
    }

    public static abstract class SchemeSocket
    extends Value
    implements Closable {
        public abstract void close() throws IOException;

        SchemeInputPort getInputPort(Interpreter interpreter) throws IOException, ContinuationException {
            return this.getInputPort(interpreter, interpreter.dynenv.characterSet);
        }

        abstract SchemeInputPort getInputPort(Interpreter var1, Charset var2) throws IOException, ContinuationException;

        abstract SchemeInputPort getBinaryInputPort(Interpreter var1) throws IOException, ContinuationException;

        abstract SchemeOutputPort getBinaryOutputPort(Interpreter var1, boolean var2) throws IOException, ContinuationException;

        SchemeOutputPort getOutputPort(Interpreter interpreter, boolean bl) throws IOException, ContinuationException {
            return this.getOutputPort(interpreter, interpreter.dynenv.characterSet, bl);
        }

        SchemeOutputPort getOutputPort(Interpreter interpreter, Charset charset) throws IOException, ContinuationException {
            return this.getOutputPort(interpreter, charset, false);
        }

        abstract SchemeOutputPort getOutputPort(Interpreter var1, Charset var2, boolean var3) throws IOException, ContinuationException;
    }

    static interface Closable {
        public void close() throws IOException;
    }
}

