/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

public class PGPSecretKeyRing {
    List keys = new ArrayList();

    PGPSecretKeyRing(List list) {
        this.keys = list;
    }

    public PGPSecretKeyRing(byte[] byArray) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray));
    }

    public PGPSecretKeyRing(InputStream inputStream) throws IOException, PGPException {
        Object object;
        Object object2;
        Packet packet;
        MessageDigest messageDigest;
        BCPGInputStream bCPGInputStream = inputStream instanceof BCPGInputStream ? (BCPGInputStream)inputStream : new BCPGInputStream(inputStream);
        int n = bCPGInputStream.nextPacketTag();
        if (n != 5 && n != 7) {
            throw new IOException("secret key ring doesn't start with secret key tag: tag 0x" + Integer.toHexString(n));
        }
        SecretKeyPacket secretKeyPacket = (SecretKeyPacket)bCPGInputStream.readPacket();
        TrustPacket trustPacket = null;
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Packet> arrayList3 = new ArrayList<Packet>();
        ArrayList arrayList4 = new ArrayList();
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("can't find SHA1 digest");
        }
        while (bCPGInputStream.nextPacketTag() == 61) {
            bCPGInputStream.readPacket();
        }
        if (bCPGInputStream.nextPacketTag() == 12) {
            trustPacket = (TrustPacket)bCPGInputStream.readPacket();
        }
        while (bCPGInputStream.nextPacketTag() == 2) {
            try {
                arrayList.add(new PGPSignature(bCPGInputStream));
            }
            catch (PGPException pGPException) {
                throw new IOException("can't create signature object: " + pGPException.getMessage() + ", cause: " + pGPException.getUnderlyingException().toString());
            }
        }
        while (bCPGInputStream.nextPacketTag() == 13 || bCPGInputStream.nextPacketTag() == 17) {
            packet = bCPGInputStream.readPacket();
            object2 = new ArrayList();
            if (packet instanceof UserIDPacket) {
                object = (UserIDPacket)packet;
                arrayList2.add(((UserIDPacket)object).getID());
            } else {
                object = (UserAttributePacket)packet;
                arrayList2.add(new PGPUserAttributeSubpacketVector(((UserAttributePacket)object).getSubpackets()));
            }
            if (bCPGInputStream.nextPacketTag() == 12) {
                arrayList3.add(bCPGInputStream.readPacket());
            } else {
                arrayList3.add(null);
            }
            arrayList4.add(object2);
            while (bCPGInputStream.nextPacketTag() == 2) {
                object = (SignaturePacket)bCPGInputStream.readPacket();
                if (bCPGInputStream.nextPacketTag() == 12) {
                    object2.add(new PGPSignature((SignaturePacket)object, (TrustPacket)bCPGInputStream.readPacket()));
                    continue;
                }
                object2.add(new PGPSignature((SignaturePacket)object));
            }
        }
        this.keys.add(new PGPSecretKey(secretKeyPacket, trustPacket, messageDigest, arrayList, arrayList2, arrayList3, arrayList4));
        while (bCPGInputStream.nextPacketTag() == 7) {
            packet = (SecretSubkeyPacket)bCPGInputStream.readPacket();
            object2 = null;
            object = new ArrayList();
            while (bCPGInputStream.nextPacketTag() == 61) {
                bCPGInputStream.readPacket();
            }
            if (bCPGInputStream.nextPacketTag() == 12) {
                object2 = (TrustPacket)bCPGInputStream.readPacket();
            }
            while (bCPGInputStream.nextPacketTag() == 2) {
                SignaturePacket signaturePacket = (SignaturePacket)bCPGInputStream.readPacket();
                if (bCPGInputStream.nextPacketTag() == 12) {
                    object.add(new PGPSignature(signaturePacket, (TrustPacket)bCPGInputStream.readPacket()));
                    continue;
                }
                object.add(new PGPSignature(signaturePacket));
            }
            this.keys.add(new PGPSecretKey((SecretKeyPacket)packet, (TrustPacket)object2, messageDigest, (List)object));
        }
    }

    public PGPPublicKey getPublicKey() {
        return ((PGPSecretKey)this.keys.get(0)).getPublicKey();
    }

    public PGPSecretKey getSecretKey() {
        return (PGPSecretKey)this.keys.get(0);
    }

    public Iterator getSecretKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public PGPSecretKey getSecretKey(long l) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)this.keys.get(i);
            if (l != pGPSecretKey.getKeyID()) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)this.keys.get(i);
            pGPSecretKey.encode(outputStream);
        }
    }

    public static PGPSecretKeyRing insertSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys);
        boolean bl = false;
        for (int i = 0; i != arrayList.size(); ++i) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)arrayList.get(i);
            if (pGPSecretKey2.getKeyID() != pGPSecretKey.getKeyID()) continue;
            bl = true;
            arrayList.set(i, pGPSecretKey);
        }
        if (!bl) {
            arrayList.add(pGPSecretKey);
        }
        return new PGPSecretKeyRing(arrayList);
    }

    public static PGPSecretKeyRing removeSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        ArrayList arrayList = new ArrayList(pGPSecretKeyRing.keys);
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)arrayList.get(i);
            if (pGPSecretKey2.getKeyID() != pGPSecretKey.getKeyID()) continue;
            bl = true;
            arrayList.remove(i);
        }
        if (!bl) {
            return null;
        }
        return new PGPSecretKeyRing(arrayList);
    }
}

