/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;

public class ClearSignedFileProcessor {
    private static PGPSecretKey readSecretKey(InputStream inputStream) throws IOException, PGPException {
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(inputStream);
        PGPSecretKey pGPSecretKey = null;
        Iterator iterator = pGPSecretKeyRingCollection.getKeyRings();
        while (pGPSecretKey == null && iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            Iterator iterator2 = pGPSecretKeyRing.getSecretKeys();
            while (pGPSecretKey == null && iterator2.hasNext()) {
                PGPSecretKey pGPSecretKey2 = (PGPSecretKey)iterator2.next();
                if (!pGPSecretKey2.isSigningKey()) continue;
                pGPSecretKey = pGPSecretKey2;
            }
        }
        if (pGPSecretKey == null) {
            throw new IllegalArgumentException("Can't find signing key in key ring.");
        }
        return pGPSecretKey;
    }

    private static void verifyFile(InputStream inputStream, InputStream inputStream2) throws Exception {
        int n;
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(inputStream);
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while ((n = armoredInputStream.read()) >= 0 && armoredInputStream.isClearText()) {
            if (n2 == 13 && n == 10) continue;
            if (bl) {
                byteArrayOutputStream.write(n2);
                bl = false;
            }
            if (n == 13 || n == 10) {
                n2 = n;
                bl = true;
                continue;
            }
            byteArrayOutputStream.write((byte)n);
            n2 = n;
        }
        PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection(inputStream2);
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(armoredInputStream);
        PGPSignatureList pGPSignatureList = (PGPSignatureList)pGPObjectFactory.nextObject();
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        pGPSignature.initVerify(pGPPublicKeyRingCollection.getPublicKey(pGPSignature.getKeyID()), "BC");
        pGPSignature.update(byteArrayOutputStream.toByteArray());
        if (pGPSignature.verify()) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }

    private static void signFile(String string, InputStream inputStream, OutputStream outputStream, char[] cArray, String string2) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException {
        int n = string2.equals("SHA256") ? 8 : (string2.equals("SHA384") ? 9 : (string2.equals("SHA512") ? 10 : (string2.equals("MD5") ? 1 : (string2.equals("RIPEMD160") ? 3 : 2))));
        PGPSecretKey pGPSecretKey = ClearSignedFileProcessor.readSecretKey(inputStream);
        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(cArray, "BC");
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(pGPSecretKey.getPublicKey().getAlgorithm(), n, "BC");
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureGenerator.initSign(1, pGPPrivateKey);
        Iterator iterator = pGPSecretKey.getPublicKey().getUserIDs();
        if (iterator.hasNext()) {
            pGPSignatureSubpacketGenerator.setSignerUserID(false, (String)iterator.next());
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        int n2 = 0;
        int n3 = 0;
        ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(outputStream);
        armoredOutputStream.beginClearText(n);
        boolean bl = false;
        while ((n2 = fileInputStream.read()) >= 0) {
            armoredOutputStream.write(n2);
            if (n3 == 13 && n2 == 10) continue;
            if (bl) {
                pGPSignatureGenerator.update((byte)n3);
                bl = false;
            }
            if (n2 == 13 || n2 == 10) {
                n3 = n2;
                bl = true;
                continue;
            }
            pGPSignatureGenerator.update((byte)n2);
            n3 = n2;
        }
        armoredOutputStream.endClearText();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(armoredOutputStream);
        pGPSignatureGenerator.generate().encode(bCPGOutputStream);
        armoredOutputStream.close();
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray[0].equals("-s")) {
            InputStream inputStream = PGPUtil.getDecoderStream(new FileInputStream(stringArray[2]));
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1] + ".asc");
            if (stringArray.length == 4) {
                ClearSignedFileProcessor.signFile(stringArray[1], inputStream, fileOutputStream, stringArray[3].toCharArray(), "SHA1");
            } else {
                ClearSignedFileProcessor.signFile(stringArray[1], inputStream, fileOutputStream, stringArray[3].toCharArray(), stringArray[4]);
            }
        } else if (stringArray[0].equals("-v")) {
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            InputStream inputStream = PGPUtil.getDecoderStream(new FileInputStream(stringArray[2]));
            ClearSignedFileProcessor.verifyFile(fileInputStream, inputStream);
        } else {
            System.err.println("usage: ClearSignedFileProcessor [-s file keyfile passPhrase]|[-v sigFile keyFile]");
        }
    }
}

