package net.lshift.sisc;

import java.io.File;
import java.io.IOException;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;


/**
 * TODO:-
 * 
 * Documentation
 * --properties <config-file>
 */
public class SiscExec extends Java {

    private File siscHome;

    private String execFile;
    
    private File heapFile;

    /* 
     * We have to set our own base dir as the one used by the Java
     * task is private
     */
    private File baseDir;

    private String sExpression;

    private String callWithArgs;
    
    private List callArgs = new ArrayList();


    public SiscExec() {
	setClassname("sisc.REPL");
	setFork(true);
	setFailonerror(true);
    }


    public void setSiscHome(File siscHome) {
	this.siscHome = siscHome;
    }


    public void setExecFile(String execFile) {
	this.execFile = execFile;
    }


    public void setHeapfile(File heapFile) {
	this.heapFile = heapFile;
    }

    
    public void setBaseDir(File baseDir) {
	this.baseDir = baseDir;
    }


    public void setSExpression(String sExpression) {
	this.sExpression = sExpression;
    }

    
    public void setCallWithArgs(String callWithArgs) {
	this.callWithArgs = callWithArgs;
    }


    public CallArg createCallArg() {
	CallArg arg = new CallArg();
	callArgs.add(arg);
	return arg;
    }


    public void execute() {
	if (baseDir == null) {
	    baseDir = new File(".");
	}

	validate();

	setDir(baseDir);
	createClasspath().setLocation(baseDir);

	createArg().setValue("--no-repl");
	
	File actualHeapFile = (heapFile == null) ? new
	    File(siscHome, "sisc.shp") : heapFile;
	
	if (!actualHeapFile.exists()) {
	    throw new BuildException("Heap file not found: " +
				     actualHeapFile);
	}
	
	createArg().setValue("--heap");
	createArg().setPath(new Path(getProject(), actualHeapFile.getAbsolutePath()));

	if (sExpression != null) {
	    createArg().setValue("--eval");
	    createArg().setValue(sExpression);
	}

	if (callWithArgs != null) {
	    createArg().setValue("--call-with-args");
	    createArg().setValue(callWithArgs);
	}

	if (execFile != null) {
	    createArg().setPath(new Path(getProject(), new
					 File(baseDir,
					      execFile).getAbsolutePath()));
	}

	if (callArgs.size() > 0) {
	    createArg().setValue("--");

	    Iterator it = callArgs.iterator();
	    while (it.hasNext()) {
		CallArg arg = (CallArg) it.next();
		createArg().setValue(arg.getValue());
	    }
        }

	log("Running SISC", Project.MSG_VERBOSE);

        super.execute();
    }

    
    private void validate() throws BuildException {
	if (!baseDir.exists()) {
	    throw new BuildException("baseDir does not exist: " +
				     baseDir);
	}

	if (siscHome == null && heapFile == null) {
	    throw new BuildException("At least one of siscHome or heapFile must be set");
	}

	if (siscHome != null && !siscHome.exists()) {
	    throw new BuildException("siscHome does not exist: " + siscHome);
	}

	if (heapFile != null && !heapFile.exists()) {
	    throw new BuildException("heapFile does not exist: " +
				     heapFile);
	}

	if (execFile == null && sExpression == null) {
	    throw new BuildException("One of execFile or sExpresison must be specified");
	}

	if (execFile != null) {
	    File realExecFile = new File(baseDir, execFile);
	    if (!realExecFile.exists()) {
		throw new BuildException("execFile does not exist: " +
					 realExecFile);
	    }
	}
    }


    public class CallArg {
	String value;

	public CallArg() {}
	public void setValue(String value) { this.value = value; }
	public String getValue() { return this.value; }
    }
}
