package net.lshift.icing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;

import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;

public class BouncyCastlePgpStringEncryptor {
    public static void initialize() {
        Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
    }
    
    public String publicKeyBlock; // ascii-armoured PGP public key block to encrypt with
    public PGPPublicKey publicKey;

    public BouncyCastlePgpStringEncryptor(String keyBlock)
        throws Exception
    {
        this.setPublicKeyBlock(keyBlock);
    }

    public void setPublicKeyBlock(String keyBlock)
        throws Exception
    {
        this.publicKeyBlock = keyBlock;
        InputStream keyInputStream =
            PGPUtil.getDecoderStream(new ByteArrayInputStream(this.publicKeyBlock.getBytes()));
        for (Iterator keyRings = new PGPPublicKeyRingCollection(keyInputStream).getKeyRings();
             keyRings.hasNext();) {
            for (Iterator keys = ((PGPPublicKeyRing) keyRings.next()).getPublicKeys();
                 keys.hasNext();) {
                PGPPublicKey key = (PGPPublicKey) keys.next();
                if (key.isEncryptionKey()) {
                    this.publicKey = key;
                    break;
                }
            }
        }
    }
    
    public String encrypt(String clearText)
        throws Exception
    {
        byte[] clearBytes = clearText.getBytes();
	return encrypt(clearBytes);
    }

    public String encrypt(byte[] clearBytes)
	throws Exception
    {
        ByteArrayOutputStream compressedClearTextStream = new ByteArrayOutputStream();
        PGPCompressedDataGenerator compressedDataGenerator =
            new PGPCompressedDataGenerator(PGPCompressedData.ZIP);
        OutputStream compressingStream = compressedDataGenerator.open(compressedClearTextStream);
        
        PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
        OutputStream clearTextCollectorStream =
            literalDataGenerator.open(compressingStream,
                                      PGPLiteralData.BINARY,
                                      "encrypted",
                                      clearBytes.length,
                                      PGPLiteralDataGenerator.NOW);

        clearTextCollectorStream.write(clearBytes);
        literalDataGenerator.close();
        compressedDataGenerator.close();

        byte[] compressedClearText = compressedClearTextStream.toByteArray();
        
        ByteArrayOutputStream armoredEncryptedText = new ByteArrayOutputStream();
        ArmoredOutputStream aStream = new ArmoredOutputStream(armoredEncryptedText);

        PGPEncryptedDataGenerator dataGenerator =
            new PGPEncryptedDataGenerator(PGPEncryptedData.CAST5, false, new SecureRandom(), "BC");
        dataGenerator.addMethod(publicKey);
        OutputStream encryptingStream = dataGenerator.open(aStream, compressedClearText.length);
        encryptingStream.write(compressedClearText);
        encryptingStream.close();
        dataGenerator.close();

        aStream.close();
        return armoredEncryptedText.toString();
    }

    public static void main(String[] args) {
        try {
            BouncyCastlePgpStringEncryptor.initialize();

            StringBuffer sb = new StringBuffer();
            while (true) {
                int c = System.in.read();
                if (c == -1) break;
                sb.append((char) c);
            }

            BouncyCastlePgpStringEncryptor e = new BouncyCastlePgpStringEncryptor(sb.toString());
            System.out.println(e.encrypt(args[0]));
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}
