(module demo-app/memoize
    (memoize-for-duration
     (define-memoized-for-duration memoize-for-duration))

  (import srfi-19)

  (define (memoize-for-duration duration-seconds thunk)
    (let ((cell #f)
	  (expiry-time #f))
      (lambda ()
	(when (or (not expiry-time)
		  (time<=? expiry-time (current-time 'time-monotonic)))
	  (set! cell (thunk))
	  (set! expiry-time (add-duration (current-time 'time-monotonic)
					  (make-time 'time-duration 0 duration-seconds))))
	cell)))

  (define-syntax define-memoized-for-duration
    (syntax-rules ()
      ((_ duration (name) body ...)
       (define name
	 (memoize-for-duration duration (lambda () body ...)))))))