(module lshift/email
    (make-address-list
     for-each-recipient-type
     make-email-message
     send-email)

  (import s2j)
  (import* type-system instance-of?)

  (define-java-classes
    <javax.mail.transport>
    <javax.mail.message>
    <javax.mail.address>
    <javax.mail.send-failed-exception>
    (<javax.mail.recipient-type> |javax.mail.Message$RecipientType|)
    (<javax.mail.mime-message> |javax.mail.internet.MimeMessage|)
    (<javax.mail.internet-address> |javax.mail.internet.InternetAddress|)
    (<java.date-time> |java.util.Date|))

  (define-generic-java-methods
    add-recipients
    add-from
    ;; set-content
    set-text
    set-subject
    set-sent-date
    send)

  (define (make-address-list l)
    (->jarray (map (lambda (address)
		     (java-new <javax.mail.internet-address> (->jstring address)))
		   l)
	      <javax.mail.address>))

  ;; (symbol x <javax.mail.recipient-type> -> void) -> void
  (define (for-each-recipient-type mapper)
    (define recipient-types
      `((to . ,((generic-java-field-accessor '|TO|) (java-null <javax.mail.recipient-type>)))
	(cc . ,((generic-java-field-accessor '|CC|) (java-null <javax.mail.recipient-type>)))
	(bcc . ,((generic-java-field-accessor '|BCC|) (java-null <javax.mail.recipient-type>)))))
    (for-each (lambda (type) (mapper (car type) (cdr type))) recipient-types))

  ;; string x <mail-session> x (list-of (list symbol string ...)) -> <javax.mail.message>
  ;; the last argument is (list-of (list recipient-type-name address))
  (define (make-email-message mail-session subject recipients)
    (define (get-recipients recipient-type)
      (let ((val (assq recipient-type recipients)))
	(make-address-list (if val (cdr val) '()))))
    (let ((message (java-new <javax.mail.mime-message> mail-session)))
      (for-each-recipient-type
       (lambda (name type)
	 (add-recipients message type
			 (get-recipients name))))
      (set-subject message (->jstring subject))
      (set-sent-date message (java-new <java.date-time>))
      message))

  (define (send-email message)
    (with/fc
	(lambda (m e)
	  (cond ((instance-of? m <javax.mail.send-failed-exception>)
		 #f)
		(else (throw m e))))
      (lambda ()
	(send (java-null <javax.mail.transport>) message)
	#t)))

  )
