(module logging
    (make-jcl-logger
     init-simple-jcl-logging
     is-jcl-enabled)

  (import s2j)

  ;; These methods are the arguments to use for the log-level argument
  ;; in procedure make-jcl-logger.
  ;;
  ;; For example, (make-jcl-logger jcl-error "foo")
  (define-generic-java-methods
    (jcl-fatal |fatal|)
    (jcl-error |error|)
    (jcl-warn |warn|)
    (jcl-info |info|)
    (jcl-debug |debug|)
    (jcl-trace |trace|))

  ;; These methods are the arguments to use for the log-level argument
  ;; in procedure is-enabled
  ;;
  ;; For example, (is-enabled jcl-is-error logger)
  (define-generic-java-methods
    (jcl-is-fatal |isFatalEnabled|)
    (jcl-is-error |isErrorEnabled|)
    (jcl-is-warn |isWarnEnabled|)
    (jcl-is-info |isInfoEnabled|)
    (jcl-is-debug |isDebugEnabled|)
    (jcl-is-trace |isTraceEnabled|))

  (define-java-classes 
    (<log> |org.apache.commons.logging.Log|)
    (<log-factory> |org.apache.commons.logging.LogFactory|)
    (<clazz> |java.lang.Class|)
    (<java-lang-system> |java.lang.System|))


  (define-generic-java-methods
    (set-system-property |setProperty|)
    (for-name |forName|)
    (get-log |getLog|))


  (define (get-jcl-java-logger name)
    (get-log (java-null <log-factory>) (->jstring name)))


  (define (make-jcl-logger log-level name)
    (let ((java-logger (get-jcl-java-logger name)))
      (lambda (message . throwable)
	(if (null? throwable)
	    (log-level java-logger (->jstring message))
	    (log-level java-logger (->jstring message) (car throwable))))))


  (define (is-jcl-enabled log-level name)
    (let ((java-logger (get-jcl-java-logger name)))
      (->boolean (log-level java-logger))))


  ;; Call this to initialize simple logging, e.g., for testing, *before* doing
  ;; anything else logging related
  (define (init-simple-jcl-logging)
    (set-system-property (java-null <java-lang-system>)
			 (->jstring "org.apache.commons.logging.Log")
			 (->jstring "org.apache.commons.logging.impl.SimpleLog"))
    (set-system-property (java-null <java-lang-system>)
			 (->jstring "org.apache.commons.logging.simplelog.defaultlog")
			 (->jstring "debug")))

  )
