(module lshift/publish-pattern
    (publication-pattern
     make-publication-pattern
     publication-pattern?
     publication-pattern-template

     publication-pattern-binding-element?
     publication-pattern-binding-name

     publish-pattern!
     match-publication-pattern
     respond-to-request!
     instantiate-publication-pattern

     forward-to-pattern
     redirect-to-pattern

     (define-publication-patterns make-publication-pattern)
     extract-publication-pattern-binding
     (binding-let extract-publication-pattern-binding)
     publication-pattern-handler
     publish-pattern

     )

  (import lshift/error)
  (import siscweb/forward)
  (import siscweb/response)
  (import siscweb/request)
  (import siscweb/error)
  (import util/regexp)
  (import utils/servlet-tools)
  (import srfi-2)
  (import srfi-9)
  (import s2j)
  (import lshift/s2j-modutils)

  ;; A utility for publishing using URLs patterns with bindings

  (module-define-generic-java-methods
   get-context-path)

  (define-record-type publication-pattern
    (make-publication-pattern* template)
    publication-pattern?
    (template publication-pattern-template))

  (define *published-patterns* '())

  (define (publication-pattern-binding-element? element)
    (and (pair? element) (eq? (car element) 'unquote)))

  (define (publication-pattern-binding-name binding) (cadr binding))

  (define (parse-publication-pattern-template template)
    (map (lambda (element)
	   (cond
	    ((string? element) element)
	    ((symbol? element) (symbol->string element))
	    ((publication-pattern-binding-element? element) element)
	    (else (error+ "Illegal pattern component in publish-pattern" element))))
	 template))

  (define (make-publication-pattern template)
    (make-publication-pattern* (parse-publication-pattern-template template)))

  (define (publish-pattern! pattern handler)
    (if (not (publication-pattern? pattern))
	(error+ "publish-pattern! expects a publication-pattern" pattern))
    (set! *published-patterns*
	  (cons (cons pattern handler) *published-patterns*)))

  (define (match-publication-pattern template value)
    (if (or (null? template) (null? value))
	(and (null? template) (null? value) '())
	(if (publication-pattern-binding-element? (car template))
	    (and-let* ((tail-bindings (match-publication-pattern (cdr template) (cdr value))))
	      (cons (list (publication-pattern-binding-name (car template))
			  (car value))
		    tail-bindings))
	    (and (equal? (car template) (car value))
		 (match-publication-pattern (cdr template) (cdr value))))))

  (define (respond-to-request! request path-info)
    (let* ((path (if (equal? "" path-info) "/" path-info))
	   (url-parts (regexp-split (make-regexp "/") path))
	   (url-parts (if (null? url-parts) url-parts (cdr url-parts))))
      (let search-candidates ((candidates *published-patterns*))
	(cond
	 ((null? candidates) (send-error/back 404 path))
	 ((match-publication-pattern (publication-pattern-template (caar candidates))
				     url-parts)
	  => (lambda (bindings)
	       ((cdar candidates) request bindings)))
	 (else (search-candidates (cdr candidates)))))))

  ;; Give a servlet-path-relative URL, given a pattern and bindings for the
  ;; variables in the pattern.  The path always starts with a slash.
  ;; %%% TO DO This won't be prefixed with the servlet path, which would be useful;
  ;; in the current deployment, however, the servlet path is empty
  ;; so we can get away with it for now.
  (define (instantiate-publication-pattern pattern bindings)
    (let* ((template (publication-pattern-template pattern))
	   (parts (map (lambda (element)
			 (cond ((string? element) element)
			       ((symbol? element) (symbol->string element))
			       ((publication-pattern-binding-element? element)
				(cond
				 ((assq (publication-pattern-binding-name element)
					bindings) => cadr)
				 (else (error+ "Missing binding in instantiation"
					       template
					       element
					       bindings))))))
		       template)))
      (string-concatenate (cons "/" (interleave-element "/" parts)))))

  (define (forward-to-pattern pattern bindings)
    (send-forward/back (instantiate-publication-pattern pattern bindings)))

  (define (redirect-to-pattern pattern bindings)
    (send/back (lambda ()
		 (redirect (current-response)
			   (->jstring
			    (string-append
			     (->string (get-context-path (current-request)))
			     (instantiate-publication-pattern pattern bindings)))))))

  (define-syntax define-publication-patterns
    (syntax-rules ()
      ((_ (name template) ...)
       (begin (define name (make-publication-pattern 'template)) ...))))

  (define (extract-publication-pattern-binding name bindings)
    (cond
     ((assq name bindings) => cadr)
     (else (error+ "Missing binding"
		   name
		   bindings))))

  (define-syntax binding-let
    (syntax-rules ()
      ((_ bindings (name ...) body ...)
       (let ((temp bindings))
	 (let ((name (extract-publication-pattern-binding 'name temp)) ...)
	   body ...)))))

  (define-syntax publication-pattern-handler
    (syntax-rules ()
      ((_ (name ...) body ...)
       (lambda (request bindings)
	 (binding-let bindings (name ...) body ...)))))

  (define-syntax publish-pattern
    (syntax-rules ()
      ((_ pattern (name ...) body ...)
       (publish-pattern! pattern
			 (publication-pattern-handler (name ...) body ...)))))

  )