(module lshift/resources
    (resource-bundles-map
     get-resource)

  (import s2j)
  (import hashtable)
  (import* type-system instance-of?)

  ;; Access to Java resource bundles

  (define-java-classes
    (<java.missing-resource-exception> |java.util.MissingResourceException|)
    (<java.resource-bundle> |java.util.ResourceBundle|)
    (<java.locale> |java.util.Locale|))

  (define-generic-java-methods
    get-bundle
    get-string
    get-default)

  ;; string x (list-of (list symbol string)  -> hashtable of symbol -> resource-bundle
  ;; The second argument is (list-of (list bundle-name-for-lookup filename))
  (define (resource-bundles-map base bundle-specs)
    (alist->hashtable
     (map (lambda (spec)
	    (cons (car spec)
		  (get-bundle (java-null <java.resource-bundle>)
			      (->jstring
			       (string-append base
					      "."
					      (cadr spec)))
			      (get-default (java-null <java.locale>)))))
	  bundle-specs)))

  ;; This didn't used to have resource-bundles as a parameter; should I go
  ;; back to having that as a global?
  ;; Nope, use cut or otherwise to provide a get-occasions-resource

  ;; (symbol -> <java.resource-bundle>) x symbol x string -> string
  (define (get-resource resource-bundle-getter bundle resource-name)
    (with/fc (lambda (m e)
	       (cond
		((instance-of? (error-message m)
			       <java.missing-resource-exception>)
		 #f)
		(else (throw m e))))
      (lambda () (->string (get-string (resource-bundle-getter bundle)
				       (->jstring resource-name))))))

  )
