(module lshift/s2j-modutils
    ((module-define-java-classes module-s2j-definition)
     (module-define-generic-java-methods module-s2j-definition))

  (import s2j)

  (define-syntax module-s2j-definition
    (lambda (stx)
      (syntax-case stx ()
	((self definer clause ...)
	 (with-syntax (((id ...) (map (lambda (clause)
					(syntax-case clause ()
					  ((id other ...) (syntax id))
					  (id (syntax id))))
				      (syntax (clause ...))))
		       (tempnam (datum->syntax-object (syntax self) (gensym))))
	   (syntax
	    (begin (module tempnam (id ...)
		     (definer clause ...))
		   (import tempnam))))))))

  (define-syntax module-define-java-classes
    (syntax-rules ()
      ((_ clause ...)
       (module-s2j-definition define-java-classes clause ...))))

  (define-syntax module-define-generic-java-methods
    (syntax-rules ()
      ((_ clause ...)
       (module-s2j-definition define-generic-java-methods clause ...)))))
