;; Our alternative to the SISCWeb sisclet.
;;
;; We use the publish-pattern procedures directly, give decent error
;; messages, and treat failed continuations better.

(module lshift/config
    (missing-k-hook)

  (define (missing-k-hook path reset-k)
    (reset-k))

  )

(module lshift/sisclet
    (sisclet)

  (import s2j)
  (define-generic-java-methods
    get-path-info)
  
  (import siscweb/contcentric)
  (import siscweb/request)
  (import siscweb/k-hash)
  (import siscweb/config)
  (import lshift/config)
  (import lshift/publish-pattern)
  
  (define (sisclet)
    (call/cc
     (lambda (suspend-k)
       (current-suspend-k suspend-k)
       (set! suspend-k #f)
       (with/fc
	   (lambda (m e)
	     ((config/get-fc-hook) m e))
	 (lambda ()
	   (let ((resume-k (fetch/k (current-k-hash))))
	     (if resume-k
		 (resume-k (current-request))
		 (let* ((path-info (get-path-info (current-request)))
			(path-info (if (java-null? path-info) "" (->string path-info)))
			(run-with-path (lambda (path-info)
					 (respond-to-request! (current-request) path-info))))
		   (if (equal? "" (extract-k-hash path-info))
		       (run-with-path path-info)
		       (missing-k-hook path-info
				       (lambda ()
					 (run-with-path (remove-k-hash path-info))))))))))))))
