(require-library 'lshift/unit-test)
(require-library 'lshift/padding)

(import unit-test)
(import padding)

(test-suite "padding-test-test-suite"
            `(
              ,(test-case "pad-string-empty-min"
                          (lambda ()
                            (assert-equivalence equal?
                                                ""
                                                (pad-string "" 0 5 #\X 'left))))


              ,(test-case "pad-string-empty-max"
                          (lambda ()
                            (assert-equivalence equal?
                                                "XXXXX"
                                                (pad-string "" 5 5 #\X 'left))))

              ,(test-case "pad-string-left"
                          (lambda ()
                            (assert-equivalence equal?
                                                "XXXOO"
                                                (pad-string "OO" 5 5 #\X 'left))))

              ,(test-case "pad-string-right"
                          (lambda ()
                            (assert-equivalence equal?
                                                "OOXXX"
                                                (pad-string "OO" 5 5 #\X 'right))))

              ,(test-case "pad-string-oversize"
                          (lambda ()
                            (assert-error
                             (lambda ()
                               (pad-string "OOOOOO" 5 5 #\X 'right)))))


              ,(test-case "pad-list-empty-min"
                          (lambda ()
                            (assert-equivalence equal?
                                                '()
                                                (pad-list '() 0 5 #\X 'left))))


              ,(test-case "pad-list-empty-max"
                          (lambda ()
                            (assert-equivalence equal?
                                                '(#\X #\X #\X #\X #\X)
                                                (pad-list '() 5 5 #\X 'left))))

              ,(test-case "pad-list-left"
                          (lambda ()
                            (assert-equivalence equal?
                                                '(#\X #\X #\X #\O #\O)
                                                (pad-list '(#\O #\O) 5 5 #\X 'left))))

              ,(test-case "pad-list-right"
                          (lambda ()
                            (assert-equivalence equal?
                                                '(#\O #\O #\X #\X #\X)
                                                (pad-list '(#\O #\O) 5 5 #\X 'right))))

              ,(test-case "pad-list-oversize"
                          (lambda ()
                            (assert-error
                             (lambda ()
                               (pad-list '(#\O #\O #\O #\O #\O #\O) 5 5 #\X 'right)))))))
