(module lshift/xslt
    (->dom
     get-servlet-helper
     do-xslt-transform
     do-xslt-transform-to-writer
     xslt-transform
     xslt-transform/dom
     current-xslt-path
     global-override-xslt-path!)

  (import s2j)
  (import srfi-2)
  (import srfi-13)
  (import utils/dom-tools)
  (import utils/servlet-tools)
  (import siscweb/request)

  ;; Support for running XML through stylesheets

  (define-java-classes
    (<servlet-helper> |net.lshift.xml.pipeline.ServletHelper|)
    (<dom-source> |javax.xml.transform.dom.DOMSource|)
    (<dom-result> |javax.xml.transform.dom.DOMResult|)
    (<stream-result> |javax.xml.transform.stream.StreamResult|)
    <java.io.string-writer>)

  (define-generic-java-methods
    set-parameter
    transform
    set-input-node
    get-pipeline
    to-string)

  (define get-servlet-helper
    (let ((servlet-helper #f))
      (define-generic-java-methods
	get-session
	get-servlet-context)
      (lambda ()
	(when (not servlet-helper)
	  ;; TODO: Refactor xml.pipeline so that it doesn't need a
	  ;; ServletContext for the basic stylesheet-caching
	  ;; functionality!
	  (and-let* ((req (current-request)))
	    (set! servlet-helper
		  (java-new <servlet-helper> (get-servlet-context (get-session req))))))
	servlet-helper)))

  (define current-xslt-path (make-parameter ""))

  (define (global-override-xslt-path! base-path)
    (set! current-xslt-path (make-parameter base-path)))

  (define (stylesheet-filename sheet)
    (string-append (current-xslt-path) (symbol->string sheet) ".xsl"))

  (define (->dom value)
    (cond ((pair? value)
	   ;; then assume SXML
	   (sxml->dom value))
	  ((symbol? value)
	   (parse-xml-file (real-path (string-append (symbol->string value) ".xhtml"))
			   #t
			   #f))
	  ;; else assume already DOM
	  (else
	   value)))

  ;; Write the transformation result
  ;; symbol x (union symbol SXML <dom.node>) x <javax.xml.transform.Result> x
  ;; (list-of (list string string)) -> void
  (define (do-xslt-transform stylesheet value result params)
    (let* ((pipeline (get-pipeline (get-servlet-helper)
				   (->jstring (stylesheet-filename stylesheet)))))
      (for-each (lambda (param)
		  (set-parameter pipeline (->jstring (car param)) (->jstring (cadr param))))
		params)
      (transform pipeline
		 (java-new <dom-source> (->dom value))
		 result)))

  (define (do-xslt-transform-to-writer stylesheet value writer params)
    (do-xslt-transform stylesheet value (java-new <stream-result> writer) params))

  ;; Return the transformation result as a string
  (define (xslt-transform stylesheet value params)
    (let ((out (java-new <java.io.string-writer>)))
      (do-xslt-transform-to-writer stylesheet value out params)
      (->string (to-string out))))

  (define (xslt-transform/dom stylesheet value params)
    (let ((doc (new-dom-document)))
      (do-xslt-transform stylesheet value (java-new <dom-result> doc) params)
      doc))

  )